/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.xz;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.xz.LzmaCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BasicArrayCache;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

@InterfaceAudience.Private
public class LzmaCompressor
implements Compressor {
    protected static final ArrayCache ARRAY_CACHE = new BasicArrayCache();
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected boolean finish;
    protected boolean finished;
    protected long bytesRead;
    protected long bytesWritten;
    protected LZMA2Options lzOptions;

    LzmaCompressor(int level, int bufferSize) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
        this.lzOptions = new LZMA2Options();
        try {
            this.lzOptions.setPreset(level);
        }
        catch (UnsupportedOptionsException e) {
            throw new RuntimeException(e);
        }
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        if (this.finish) {
            if (this.inBuf.position() > 0) {
                ByteBuffer writeBuffer;
                this.inBuf.flip();
                int uncompressed = this.inBuf.remaining();
                int needed = this.maxCompressedLength(uncompressed);
                boolean direct = false;
                if (len <= needed) {
                    writeBuffer = ByteBuffer.wrap(b, off, len);
                    direct = true;
                } else {
                    if (this.outBuf.capacity() < needed) {
                        needed = CompressionUtil.roundInt2((int)needed);
                        this.outBuf = ByteBuffer.allocate(needed);
                    } else {
                        this.outBuf.clear();
                    }
                    writeBuffer = this.outBuf;
                }
                int oldPos = writeBuffer.position();
                try (ByteBufferOutputStream lowerOut = new ByteBufferOutputStream(writeBuffer){

                    protected void checkSizeAndGrow(int extra) {
                        long capacityNeeded = (long)this.curBuf.position() + (long)extra;
                        if (capacityNeeded > (long)this.curBuf.limit()) {
                            throw new BufferOverflowException();
                        }
                    }
                };
                     LZMAOutputStream out = new LZMAOutputStream((OutputStream)lowerOut, this.lzOptions, (long)uncompressed, ARRAY_CACHE);){
                    out.write(this.inBuf.array(), this.inBuf.arrayOffset(), uncompressed);
                }
                int written = writeBuffer.position() - oldPos;
                this.bytesWritten += (long)written;
                this.inBuf.clear();
                this.finished = true;
                this.outBuf.flip();
                if (!direct) {
                    int n = Math.min(written, len);
                    this.outBuf.get(b, off, n);
                    return n;
                }
                return written;
            }
            this.finished = true;
        }
        return 0;
    }

    public void end() {
    }

    public void finish() {
        this.finish = true;
    }

    public boolean finished() {
        return this.finished && !this.outBuf.hasRemaining();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean needsInput() {
        return !this.finished();
    }

    public void reinit(Configuration conf) {
        if (conf != null) {
            try {
                int level = LzmaCodec.getLevel(conf);
                this.lzOptions = new LZMA2Options();
                this.lzOptions.setPreset(level);
            }
            catch (UnsupportedOptionsException e) {
                throw new RuntimeException(e);
            }
            int newBufferSize = LzmaCodec.getBufferSize(conf);
            if (this.bufferSize != newBufferSize) {
                this.bufferSize = newBufferSize;
                this.inBuf = ByteBuffer.allocate(this.bufferSize);
                this.outBuf = ByteBuffer.allocate(this.bufferSize);
            }
        }
        this.reset();
    }

    public void reset() {
        this.inBuf.clear();
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.finish = false;
        this.finished = false;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.bytesRead += (long)len;
        this.finished = false;
    }

    int maxCompressedLength(int len) {
        return len + CompressionUtil.compressionOverhead((int)len);
    }
}

