/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.api;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.impl.RegistryOperationsClient;
import org.apache.hadoop.util.Preconditions;

public final class RegistryOperationsFactory {
    private RegistryOperationsFactory() {
    }

    public static RegistryOperations createInstance(Configuration conf) {
        return RegistryOperationsFactory.createInstance("RegistryOperations", conf);
    }

    public static RegistryOperations createInstance(String name, Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        RegistryOperationsClient operations = new RegistryOperationsClient(name);
        operations.init(conf);
        return operations;
    }

    public static RegistryOperationsClient createClient(String name, Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        RegistryOperationsClient operations = new RegistryOperationsClient(name);
        operations.init(conf);
        return operations;
    }

    public static RegistryOperations createAnonymousInstance(Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "");
        return RegistryOperationsFactory.createInstance("AnonymousRegistryOperations", conf);
    }

    public static RegistryOperations createKerberosInstance(Configuration conf, String jaasContext) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "kerberos");
        conf.set("hadoop.registry.jaas.context", jaasContext);
        return RegistryOperationsFactory.createInstance("KerberosRegistryOperations", conf);
    }

    public static RegistryOperations createKerberosInstance(Configuration conf, String jaasClientEntry, String principal, String keytab) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "kerberos");
        conf.set("hadoop.registry.jaas.context", jaasClientEntry);
        RegistryOperationsClient operations = new RegistryOperationsClient("KerberosRegistryOperations");
        operations.setKerberosPrincipalAndKeytab(principal, keytab);
        operations.init(conf);
        return operations;
    }

    public static RegistryOperations createAuthenticatedInstance(Configuration conf, String id, String password) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)id) ? 1 : 0) != 0, (Object)"empty Id");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)password) ? 1 : 0) != 0, (Object)"empty Password");
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"Null configuration");
        conf.set("hadoop.registry.client.auth", "digest");
        conf.set("hadoop.registry.client.auth.id", id);
        conf.set("hadoop.registry.client.auth.password", password);
        return RegistryOperationsFactory.createInstance("DigestRegistryOperations", conf);
    }
}

