/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Interceptor;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.utils.DebugPoint;

public final class AsyncReadQueueRecord
extends AsyncQueueRecord<ReadResult> {
    private static final ThreadCache.CachedTypeIndex<AsyncReadQueueRecord> CACHE_IDX = ThreadCache.obtainIndex(AsyncReadQueueRecord.class, 2);
    protected Interceptor interceptor;

    public static AsyncReadQueueRecord create(Connection connection, Buffer message, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        AsyncReadQueueRecord asyncReadQueueRecord = ThreadCache.takeFromCache(CACHE_IDX);
        if (asyncReadQueueRecord != null) {
            asyncReadQueueRecord.isRecycled = false;
            asyncReadQueueRecord.interceptor = interceptor;
            asyncReadQueueRecord.set(connection, message, currentResult, completionHandler);
            return asyncReadQueueRecord;
        }
        return new AsyncReadQueueRecord(connection, message, currentResult, completionHandler, interceptor);
    }

    private AsyncReadQueueRecord(Connection connection, Buffer message, ReadResult currentResult, CompletionHandler completionHandler, Interceptor<ReadResult> interceptor) {
        super(connection, message, currentResult, completionHandler);
        this.interceptor = interceptor;
    }

    public final Interceptor getInterceptor() {
        this.checkRecycled();
        return this.interceptor;
    }

    public final void notifyComplete() {
        if (this.completionHandler != null) {
            this.completionHandler.completed(this.currentResult);
        }
    }

    public boolean isFinished() {
        return ((ReadResult)this.currentResult).getReadSize() > 0 || !((Buffer)this.message).hasRemaining();
    }

    protected final void reset() {
        this.set(null, null, null, null);
        this.interceptor = null;
    }

    @Override
    public void recycle() {
        this.checkRecycled();
        this.reset();
        this.isRecycled = true;
        if (Grizzly.isTrackingThreadCache()) {
            this.recycleTrack = new DebugPoint(new Exception(), Thread.currentThread().getName());
        }
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

