#!/bin/sh
# ----------------------------------------------------------------------------
#  Copyright 2001-2006 The Apache Software Foundation.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
# ----------------------------------------------------------------------------

#   Copyright (c) 2001-2002 The Apache Software Foundation.  All rights
#   reserved.

BASEDIR=`dirname $0`/..
BASEDIR=`(cd "$BASEDIR"; pwd)`



# OS specific support.  $var _must_ be set to either true or false.
cygwin=false;
darwin=false;
case "`uname`" in
  CYGWIN*) cygwin=true ;;
  Darwin*) darwin=true
           if [ -z "$JAVA_VERSION" ] ; then
             JAVA_VERSION="CurrentJDK"
           else
             echo "Using Java version: $JAVA_VERSION"
           fi
           if [ -z "$JAVA_HOME" ] ; then
             JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Versions/${JAVA_VERSION}/Home
           fi
           ;;
esac

if [ -z "$JAVA_HOME" ] ; then
  if [ -r /etc/gentoo-release ] ; then
    JAVA_HOME=`java-config --jre-home`
  fi
fi

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin ; then
  [ -n "$JAVA_HOME" ] && JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
  [ -n "$CLASSPATH" ] && CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

# If a specific java binary isn't specified search for the standard 'java' binary
if [ -z "$JAVACMD" ] ; then
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then
      # IBM's JDK on AIX uses strange locations for the executables
      JAVACMD="$JAVA_HOME/jre/sh/java"
    else
      JAVACMD="$JAVA_HOME/bin/java"
    fi
  else
    JAVACMD=`which java`
  fi
fi

if [ ! -x "$JAVACMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JAVACMD"
  exit 1
fi

if [ -z "$REPO" ]
then
  REPO="$BASEDIR"/repo
fi

CLASSPATH=$CLASSPATH_PREFIX:"$BASEDIR"/conf:"$REPO"/org/apache/helix/helix-common/1.1.0/helix-common-1.1.0.jar:"$REPO"/org/apache/helix/metrics-common/1.1.0/metrics-common-1.1.0.jar:"$REPO"/org/apache/helix/zookeeper-api/1.1.0/zookeeper-api-1.1.0.jar:"$REPO"/org/apache/helix/metadata-store-directory-common/1.1.0/metadata-store-directory-common-1.1.0.jar:"$REPO"/org/apache/commons/commons-lang3/3.8.1/commons-lang3-3.8.1.jar:"$REPO"/org/apache/zookeeper/zookeeper/3.6.3/zookeeper-3.6.3.jar:"$REPO"/org/apache/zookeeper/zookeeper-jute/3.6.3/zookeeper-jute-3.6.3.jar:"$REPO"/org/apache/yetus/audience-annotations/0.5.0/audience-annotations-0.5.0.jar:"$REPO"/io/netty/netty-handler/4.1.63.Final/netty-handler-4.1.63.Final.jar:"$REPO"/io/netty/netty-common/4.1.63.Final/netty-common-4.1.63.Final.jar:"$REPO"/io/netty/netty-resolver/4.1.63.Final/netty-resolver-4.1.63.Final.jar:"$REPO"/io/netty/netty-buffer/4.1.63.Final/netty-buffer-4.1.63.Final.jar:"$REPO"/io/netty/netty-transport/4.1.63.Final/netty-transport-4.1.63.Final.jar:"$REPO"/io/netty/netty-codec/4.1.63.Final/netty-codec-4.1.63.Final.jar:"$REPO"/io/netty/netty-transport-native-epoll/4.1.63.Final/netty-transport-native-epoll-4.1.63.Final.jar:"$REPO"/io/netty/netty-transport-native-unix-common/4.1.63.Final/netty-transport-native-unix-common-4.1.63.Final.jar:"$REPO"/javax/annotation/javax.annotation-api/1.3.2/javax.annotation-api-1.3.2.jar:"$REPO"/org/slf4j/slf4j-api/1.7.32/slf4j-api-1.7.32.jar:"$REPO"/org/apache/logging/log4j/log4j-slf4j-impl/2.17.1/log4j-slf4j-impl-2.17.1.jar:"$REPO"/org/apache/logging/log4j/log4j-api/2.17.1/log4j-api-2.17.1.jar:"$REPO"/org/apache/logging/log4j/log4j-core/2.17.1/log4j-core-2.17.1.jar:"$REPO"/com/fasterxml/jackson/core/jackson-databind/2.12.6.1/jackson-databind-2.12.6.1.jar:"$REPO"/com/fasterxml/jackson/core/jackson-annotations/2.12.6/jackson-annotations-2.12.6.jar:"$REPO"/com/fasterxml/jackson/core/jackson-core/2.12.6/jackson-core-2.12.6.jar:"$REPO"/commons-io/commons-io/2.11.0/commons-io-2.11.0.jar:"$REPO"/commons-cli/commons-cli/1.2/commons-cli-1.2.jar:"$REPO"/org/apache/commons/commons-math/2.1/commons-math-2.1.jar:"$REPO"/org/apache/commons/commons-math3/3.6.1/commons-math3-3.6.1.jar:"$REPO"/commons-codec/commons-codec/1.6/commons-codec-1.6.jar:"$REPO"/com/google/guava/guava/31.1-jre/guava-31.1-jre.jar:"$REPO"/com/google/guava/failureaccess/1.0.1/failureaccess-1.0.1.jar:"$REPO"/com/google/guava/listenablefuture/9999.0-empty-to-avoid-conflict-with-guava/listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar:"$REPO"/com/google/code/findbugs/jsr305/3.0.2/jsr305-3.0.2.jar:"$REPO"/org/checkerframework/checker-qual/3.12.0/checker-qual-3.12.0.jar:"$REPO"/com/google/errorprone/error_prone_annotations/2.11.0/error_prone_annotations-2.11.0.jar:"$REPO"/com/google/j2objc/j2objc-annotations/1.3/j2objc-annotations-1.3.jar:"$REPO"/org/yaml/snakeyaml/1.30/snakeyaml-1.30.jar:"$REPO"/io/dropwizard/metrics/metrics-core/4.1.14/metrics-core-4.1.14.jar:"$REPO"/org/apache/httpcomponents/httpclient/4.5.13/httpclient-4.5.13.jar:"$REPO"/org/apache/httpcomponents/httpcore/4.4.13/httpcore-4.4.13.jar:"$REPO"/commons-logging/commons-logging/1.2/commons-logging-1.2.jar:"$REPO"/javax/xml/bind/jaxb-api/2.1/jaxb-api-2.1.jar:"$REPO"/javax/xml/stream/stax-api/1.0-2/stax-api-1.0-2.jar:"$REPO"/javax/activation/activation/1.1/activation-1.1.jar:"$REPO"/org/xerial/snappy/snappy-java/1.1.7/snappy-java-1.1.7.jar:"$REPO"/org/apache/helix/helix-core/1.1.0/helix-core-1.1.0.jar
EXTRA_JVM_ARGUMENTS="-Dlog4j2.formatMsgNoLookups=true -Dlog4j2.configurationFile=file://"$BASEDIR"/conf/log4j2.properties"

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
  [ -n "$CLASSPATH" ] && CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
  [ -n "$JAVA_HOME" ] && JAVA_HOME=`cygpath --path --windows "$JAVA_HOME"`
  [ -n "$HOME" ] && HOME=`cygpath --path --windows "$HOME"`
  [ -n "$BASEDIR" ] && BASEDIR=`cygpath --path --windows "$BASEDIR"`
  [ -n "$REPO" ] && REPO=`cygpath --path --windows "$REPO"`
fi

exec "$JAVACMD" $JAVA_OPTS \
  $EXTRA_JVM_ARGUMENTS \
  -classpath "$CLASSPATH" \
  -Dapp.name="yaml-cluster-setup" \
  -Dapp.pid="$$" \
  -Dapp.repo="$REPO" \
  -Dbasedir="$BASEDIR" \
  org.apache.helix.tools.commandtools.YAMLClusterSetup \
  "$@"
