/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.metadatastore;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.common.HelixRestNamespace;
import org.apache.helix.rest.common.HelixRestUtils;
import org.apache.helix.rest.metadatastore.MetadataStoreDirectory;
import org.apache.helix.rest.metadatastore.ZkMetadataStoreDirectory;
import org.apache.helix.rest.metadatastore.datamodel.MetadataStoreShardingKey;
import org.apache.helix.rest.metadatastore.datamodel.MetadataStoreShardingKeysByRealm;
import org.apache.helix.rest.server.filters.NamespaceAuth;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NamespaceAuth
@Path(value="")
public class MetadataStoreDirectoryAccessor
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataStoreDirectoryAccessor.class);
    private String _namespace;
    protected MetadataStoreDirectory _metadataStoreDirectory;

    @PostConstruct
    private void postConstruct() {
        HelixRestNamespace helixRestNamespace = this.getHelixNamespace();
        this._namespace = helixRestNamespace.getName();
        this.buildMetadataStoreDirectory(this._namespace, helixRestNamespace.getMetadataStoreAddress());
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="/metadata-store-namespaces")
    public Response getAllNamespaces() {
        Collection<String> namespaces = this._metadataStoreDirectory.getAllNamespaces();
        ImmutableMap responseMap = ImmutableMap.of((Object)"namespaces", namespaces);
        return this.JSONRepresentation(responseMap);
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="/metadata-store-realms")
    public Response getAllMetadataStoreRealms(@QueryParam(value="sharding-key") String shardingKey) {
        try {
            if (shardingKey == null) {
                Collection<String> realms = this._metadataStoreDirectory.getAllMetadataStoreRealms(this._namespace);
                ImmutableMap responseMap = ImmutableMap.of((Object)"realms", realms);
                return this.JSONRepresentation(responseMap);
            }
            String realm = this._metadataStoreDirectory.getMetadataStoreRealm(this._namespace, shardingKey);
            return this.JSONRepresentation(new MetadataStoreShardingKey(shardingKey, realm));
        }
        catch (NoSuchElementException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="/metadata-store-realms/{realm}")
    public Response addMetadataStoreRealm(@PathParam(value="realm") String realm) {
        try {
            if (!this._metadataStoreDirectory.addMetadataStoreRealm(this._namespace, realm)) {
                return this.serverError();
            }
        }
        catch (IllegalArgumentException ex) {
            return this.notFound(ex.getMessage());
        }
        return this.created();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="/metadata-store-realms/{realm}")
    public Response deleteMetadataStoreRealm(@PathParam(value="realm") String realm) {
        try {
            if (!this._metadataStoreDirectory.deleteMetadataStoreRealm(this._namespace, realm)) {
                return this.serverError();
            }
        }
        catch (IllegalArgumentException ex) {
            return this.notFound(ex.getMessage());
        }
        return this.OK();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="/sharding-keys")
    public Response getShardingKeys(@QueryParam(value="prefix") String prefix) {
        try {
            if (prefix == null) {
                return this.getAllShardingKeys();
            }
            return this.getAllShardingKeysUnderPath(prefix);
        }
        catch (NoSuchElementException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="/routing-data")
    public Response getRoutingData() {
        Map<String, List<String>> rawRoutingData;
        try {
            rawRoutingData = this._metadataStoreDirectory.getNamespaceRoutingData(this._namespace);
        }
        catch (NoSuchElementException ex) {
            return this.notFound(ex.getMessage());
        }
        List shardingKeysByRealm = rawRoutingData.entrySet().stream().map(entry -> new MetadataStoreShardingKeysByRealm((String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
        ImmutableMap responseMap = ImmutableMap.of((Object)"namespace", (Object)this._namespace, (Object)"routingData", shardingKeysByRealm);
        return this.JSONRepresentation(responseMap);
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="/routing-data")
    @Consumes(value={"application/json"})
    public Response setRoutingData(String jsonContent) {
        try {
            Map routingData = (Map)OBJECT_MAPPER.readValue(jsonContent, (TypeReference)new TypeReference<HashMap<String, List<String>>>(){});
            if (!this._metadataStoreDirectory.setNamespaceRoutingData(this._namespace, routingData)) {
                return this.serverError();
            }
        }
        catch (JsonParseException | JsonMappingException | IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
        catch (IOException e) {
            return this.serverError(e);
        }
        return this.created();
    }

    @ResponseMetered(name="read")
    @Timed(name="read")
    @GET
    @Path(value="/metadata-store-realms/{realm}/sharding-keys")
    public Response getRealmShardingKeys(@PathParam(value="realm") String realm, @QueryParam(value="prefix") String prefix) {
        try {
            if (prefix == null) {
                return this.getAllShardingKeysInRealm(realm);
            }
            return this.getRealmShardingKeysUnderPath(realm, prefix);
        }
        catch (NoSuchElementException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @PUT
    @Path(value="/metadata-store-realms/{realm}/sharding-keys/{sharding-key: .+}")
    public Response addShardingKey(@PathParam(value="realm") String realm, @PathParam(value="sharding-key") String shardingKey) {
        shardingKey = "/" + shardingKey;
        try {
            if (!this._metadataStoreDirectory.addShardingKey(this._namespace, realm, shardingKey)) {
                return this.serverError();
            }
        }
        catch (NoSuchElementException ex) {
            return this.notFound(ex.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.badRequest(e.getMessage());
        }
        return this.created();
    }

    @ResponseMetered(name="write")
    @Timed(name="write")
    @DELETE
    @Path(value="/metadata-store-realms/{realm}/sharding-keys/{sharding-key: .+}")
    public Response deleteShardingKey(@PathParam(value="realm") String realm, @PathParam(value="sharding-key") String shardingKey) {
        shardingKey = "/" + shardingKey;
        try {
            if (!this._metadataStoreDirectory.deleteShardingKey(this._namespace, realm, shardingKey)) {
                return this.serverError();
            }
        }
        catch (IllegalArgumentException ex) {
            return this.notFound(ex.getMessage());
        }
        return this.OK();
    }

    private HelixRestNamespace getHelixNamespace() {
        HelixRestNamespace helixRestNamespace = null;
        if (HelixRestUtils.isDefaultServlet(this._servletRequest.getServletPath())) {
            List namespaces = (List)this._application.getProperties().get(ContextPropertyKeys.ALL_NAMESPACES.name());
            for (HelixRestNamespace ns : namespaces) {
                if (!"default".equals(ns.getName())) continue;
                helixRestNamespace = ns;
                break;
            }
        } else {
            helixRestNamespace = (HelixRestNamespace)this._application.getProperties().get(ContextPropertyKeys.METADATA.name());
        }
        return helixRestNamespace;
    }

    protected void buildMetadataStoreDirectory(String namespace, String address) {
        try {
            this._metadataStoreDirectory = ZkMetadataStoreDirectory.getInstance(namespace, address);
        }
        catch (InvalidRoutingDataException ex) {
            LOG.warn("Unable to create metadata store directory for namespace: {}, ZK address: {}", new Object[]{namespace, address, ex});
        }
    }

    private Response getAllShardingKeys() {
        Collection<String> shardingKeys = this._metadataStoreDirectory.getAllShardingKeys(this._namespace);
        ImmutableMap responseMap = ImmutableMap.of((Object)"namespace", (Object)this._namespace, (Object)"shardingKeys", shardingKeys);
        return this.JSONRepresentation(responseMap);
    }

    private Response getAllShardingKeysInRealm(String realm) {
        Collection<String> shardingKeys = this._metadataStoreDirectory.getAllShardingKeysInRealm(this._namespace, realm);
        ImmutableMap responseMap = ImmutableMap.of((Object)"realm", (Object)realm, (Object)"shardingKeys", shardingKeys);
        return this.JSONRepresentation(responseMap);
    }

    private Response getAllShardingKeysUnderPath(String prefix) {
        List shardingKeyList = this._metadataStoreDirectory.getAllMappingUnderPath(this._namespace, prefix).entrySet().stream().map(entry -> new MetadataStoreShardingKey((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        ImmutableMap responseMap = ImmutableMap.of((Object)"prefix", (Object)prefix, (Object)"shardingKeys", shardingKeyList);
        return this.JSONRepresentation(responseMap);
    }

    private Response getRealmShardingKeysUnderPath(String realm, String prefix) {
        List shardingKeyList = this._metadataStoreDirectory.getAllMappingUnderPath(this._namespace, prefix).entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(realm)).map(Map.Entry::getKey).collect(Collectors.toList());
        ImmutableMap responseMap = ImmutableMap.of((Object)"prefix", (Object)prefix, (Object)"realm", (Object)realm, (Object)"shardingKeys", shardingKeyList);
        return this.JSONRepresentation(responseMap);
    }
}

