/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.api.status;

import org.apache.helix.model.LiveInstance;

public class ClusterManagementMode {
    private final Type mode;
    private final Status status;

    private ClusterManagementMode() {
        this.mode = null;
        this.status = null;
    }

    public ClusterManagementMode(Type mode, Status status) {
        this.mode = mode;
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public Type getMode() {
        return this.mode;
    }

    public boolean isFullyInNormalMode() {
        return Type.NORMAL.equals((Object)this.mode) && Status.COMPLETED.equals((Object)this.status);
    }

    public LiveInstance.LiveInstanceStatus getDesiredParticipantStatus() {
        switch (this.mode) {
            case CLUSTER_FREEZE: {
                return LiveInstance.LiveInstanceStatus.FROZEN;
            }
            case NORMAL: {
                return LiveInstance.LiveInstanceStatus.NORMAL;
            }
        }
        return null;
    }

    public static enum Status {
        IN_PROGRESS,
        COMPLETED;

    }

    public static enum Type {
        NORMAL,
        CLUSTER_FREEZE,
        CONTROLLER_PAUSE,
        MAINTENANCE;

    }
}

