/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Map;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class NodeCapacityConstraint
extends HardConstraint {
    NodeCapacityConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        Map<String, Integer> nodeCapacity = node.getRemainingCapacity();
        Map<String, Integer> replicaCapacity = replica.getCapacity();
        for (String key : replicaCapacity.keySet()) {
            if (!nodeCapacity.containsKey(key) || nodeCapacity.get(key) >= replicaCapacity.get(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    String getDescription() {
        return "Node has insufficient capacity";
    }
}

