/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.callback;

import org.apache.helix.zookeeper.zkclient.callback.CancellableZkAsyncCallback;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallMonitorContext;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncRetryThread;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkAsyncRetryCallContext
extends ZkAsyncCallMonitorContext {
    private static Logger LOG = LoggerFactory.getLogger(ZkAsyncRetryCallContext.class);
    private final ZkAsyncRetryThread _retryThread;
    private final CancellableZkAsyncCallback _cancellableCallback;

    public ZkAsyncRetryCallContext(ZkAsyncRetryThread retryThread, CancellableZkAsyncCallback callback, ZkClientMonitor monitor, long startTimeMilliSec, int bytes, boolean isRead, boolean isCompressed) {
        super(monitor, startTimeMilliSec, bytes, isRead, isCompressed);
        this._retryThread = retryThread;
        this._cancellableCallback = callback;
    }

    public ZkAsyncRetryCallContext(ZkAsyncRetryThread retryThread, CancellableZkAsyncCallback callback, ZkClientMonitor monitor, long startTimeMilliSec, int bytes, boolean isRead) {
        this(retryThread, callback, monitor, startTimeMilliSec, bytes, isRead, false);
    }

    boolean requestRetry() {
        return this._retryThread.sendRetryRequest(this);
    }

    void cancel() {
        this._cancellableCallback.notifyCallers();
    }

    protected abstract void doRetry() throws Exception;
}

