/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.apache.helix.task.TaskState;

public class WorkflowMonitor
extends DynamicMBeanProvider {
    private static final String MBEAN_DESCRIPTION = "Workflow Monitor";
    private static final String WORKFLOW_KEY = "Workflow";
    static final String WORKFLOW_TYPE_DN_KEY = "workflowType";
    private static final long DEFAULT_RESET_INTERVAL_MS = 3600000L;
    private String _clusterName;
    private String _workflowType;
    private SimpleDynamicMetric<Long> _successfulWorkflowCount;
    private SimpleDynamicMetric<Long> _failedWorkflowCount;
    private SimpleDynamicMetric<Long> _failedWorkflowGauge;
    private SimpleDynamicMetric<Long> _existingWorkflowGauge;
    private SimpleDynamicMetric<Long> _queuedWorkflowGauge;
    private SimpleDynamicMetric<Long> _runningWorkflowGauge;
    private SimpleDynamicMetric<Long> _totalWorkflowLatencyCount;
    private SimpleDynamicMetric<Long> _maximumWorkflowLatencyGauge;
    private SimpleDynamicMetric<Long> _lastResetTime;

    public WorkflowMonitor(String clusterName, String workflowType) {
        this._clusterName = clusterName;
        this._workflowType = workflowType;
        this._successfulWorkflowCount = new SimpleDynamicMetric<Long>("SuccessfulWorkflowCount", 0L);
        this._failedWorkflowCount = new SimpleDynamicMetric<Long>("FailedWorkflowCount", 0L);
        this._failedWorkflowGauge = new SimpleDynamicMetric<Long>("FailedWorkflowGauge", 0L);
        this._existingWorkflowGauge = new SimpleDynamicMetric<Long>("ExistingWorkflowGauge", 0L);
        this._queuedWorkflowGauge = new SimpleDynamicMetric<Long>("QueuedWorkflowGauge", 0L);
        this._runningWorkflowGauge = new SimpleDynamicMetric<Long>("RunningWorkflowGauge", 0L);
        this._totalWorkflowLatencyCount = new SimpleDynamicMetric<Long>("TotalWorkflowLatencyCount", 0L);
        this._maximumWorkflowLatencyGauge = new SimpleDynamicMetric<Long>("MaximumWorkflowLatencyGauge", 0L);
        this._lastResetTime = new SimpleDynamicMetric<Long>("LastResetTime", System.currentTimeMillis());
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s", this._clusterName, WORKFLOW_KEY, this._workflowType);
    }

    public void updateWorkflowCounters(TaskState to) {
        this.updateWorkflowCounters(to, 0L);
    }

    public void updateWorkflowCounters(TaskState to, long latency) {
        if (to.equals((Object)TaskState.FAILED)) {
            this.incrementSimpleDynamicMetric(this._failedWorkflowCount, 1L);
        } else if (to.equals((Object)TaskState.COMPLETED)) {
            this.incrementSimpleDynamicMetric(this._successfulWorkflowCount, 1L);
            this.incrementSimpleDynamicMetric(this._maximumWorkflowLatencyGauge, this._maximumWorkflowLatencyGauge.getValue() > latency ? 0L : latency - this._maximumWorkflowLatencyGauge.getValue());
            this.incrementSimpleDynamicMetric(this._totalWorkflowLatencyCount, latency > 0L ? latency : 0L);
        }
    }

    public void resetGauges() {
        this._failedWorkflowGauge.updateValue(0L);
        this._existingWorkflowGauge.updateValue(0L);
        this._runningWorkflowGauge.updateValue(0L);
        this._queuedWorkflowGauge.updateValue(0L);
        if (this._lastResetTime.getValue() + 3600000L < System.currentTimeMillis()) {
            this._lastResetTime.updateValue(System.currentTimeMillis());
            this._maximumWorkflowLatencyGauge.updateValue(0L);
        }
    }

    public void updateWorkflowGauges(TaskState current) {
        if (current == null || current.equals((Object)TaskState.NOT_STARTED)) {
            this.incrementSimpleDynamicMetric(this._queuedWorkflowGauge);
        } else if (current.equals((Object)TaskState.IN_PROGRESS)) {
            this.incrementSimpleDynamicMetric(this._runningWorkflowGauge);
        } else if (current.equals((Object)TaskState.FAILED)) {
            this.incrementSimpleDynamicMetric(this._failedWorkflowGauge);
        }
        this.incrementSimpleDynamicMetric(this._existingWorkflowGauge);
    }

    public long getSuccessfulWorkflowCount() {
        return this._successfulWorkflowCount.getValue();
    }

    public long getFailedWorkflowCount() {
        return this._failedWorkflowCount.getValue();
    }

    public long getFailedWorkflowGauge() {
        return this._failedWorkflowGauge.getValue();
    }

    public long getExistingWorkflowGauge() {
        return this._existingWorkflowGauge.getValue();
    }

    public long getQueuedWorkflowGauge() {
        return this._queuedWorkflowGauge.getValue();
    }

    public long getRunningWorkflowGauge() {
        return this._runningWorkflowGauge.getValue();
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._successfulWorkflowCount);
        attributeList.add(this._failedWorkflowCount);
        attributeList.add(this._failedWorkflowGauge);
        attributeList.add(this._existingWorkflowGauge);
        attributeList.add(this._queuedWorkflowGauge);
        attributeList.add(this._runningWorkflowGauge);
        attributeList.add(this._totalWorkflowLatencyCount);
        attributeList.add(this._maximumWorkflowLatencyGauge);
        attributeList.add(this._lastResetTime);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this.getObjectName(this._workflowType));
        return this;
    }

    private ObjectName getObjectName(String workflowType) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s", MonitorDomainNames.ClusterStatus.name(), String.format("%s, %s=%s", String.format("%s=%s", "cluster", this._clusterName), WORKFLOW_TYPE_DN_KEY, workflowType)));
    }
}

