/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelDeserializer
extends JsonDeserializer<Model> {
    public Model deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node.get("$ref");
        JsonNode allOf = node.get("allOf");
        if (sub != null) {
            return (Model)Json.mapper().convertValue((Object)sub, RefModel.class);
        }
        if (allOf != null) {
            ComposedModel model = null;
            model = (ComposedModel)Json.mapper().convertValue((Object)node, ComposedModel.class);
            List allComponents = model.getAllOf();
            if (allComponents.size() >= 1) {
                model.setParent((Model)allComponents.get(0));
                if (allComponents.size() >= 2) {
                    model.setChild((Model)allComponents.get(allComponents.size() - 1));
                    ArrayList<RefModel> interfaces = new ArrayList<RefModel>();
                    int size = allComponents.size();
                    for (Model m : allComponents.subList(1, size - 1)) {
                        if (!(m instanceof RefModel)) continue;
                        RefModel ref = (RefModel)m;
                        interfaces.add(ref);
                    }
                    model.setInterfaces(interfaces);
                } else {
                    model.setChild((Model)new ModelImpl());
                }
            }
            return model;
        }
        sub = node.get("type");
        Model model = null;
        model = sub != null && "array".equals(((TextNode)sub).textValue()) ? (Model)Json.mapper().convertValue((Object)node, ArrayModel.class) : (Model)Json.mapper().convertValue((Object)node, ModelImpl.class);
        return model;
    }
}

