/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event.helix;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.cloud.event.CloudEventListener;
import org.apache.helix.cloud.event.helix.CloudEventCallbackProperty;
import org.apache.helix.cloud.event.helix.DefaultCloudEventCallbackImpl;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixCloudEventListener
implements CloudEventListener {
    private static Logger LOG = LoggerFactory.getLogger(HelixCloudEventListener.class);
    private final CloudEventCallbackProperty _property;
    private final DefaultCloudEventCallbackImpl _callbackImplClass;
    private final HelixManager _helixManager;
    private final List<Object> onPauseOperations = Arrays.asList(new Object[]{CloudEventCallbackProperty.UserDefinedCallbackType.PRE_ON_PAUSE, CloudEventCallbackProperty.HelixOperation.MAINTENANCE_MODE, CloudEventCallbackProperty.HelixOperation.ENABLE_DISABLE_INSTANCE, CloudEventCallbackProperty.UserDefinedCallbackType.POST_ON_PAUSE});
    private final List<Object> onResumeOperations = Arrays.asList(new Object[]{CloudEventCallbackProperty.UserDefinedCallbackType.PRE_ON_RESUME, CloudEventCallbackProperty.HelixOperation.ENABLE_DISABLE_INSTANCE, CloudEventCallbackProperty.HelixOperation.MAINTENANCE_MODE, CloudEventCallbackProperty.UserDefinedCallbackType.POST_ON_RESUME});

    public HelixCloudEventListener(CloudEventCallbackProperty property, HelixManager helixManager) throws InstantiationException, IllegalAccessException {
        this._property = property;
        this._helixManager = helixManager;
        this._callbackImplClass = this.loadCloudEventCallbackImplClass(property.getUserArgs().getOrDefault("callbackImplClassName", DefaultCloudEventCallbackImpl.class.getCanonicalName()));
    }

    @Override
    public void performAction(Object eventType, Object eventInfo) {
        LOG.info("Received {} event, event info {}, timestamp {}. Acting on the event... Actor {}, based on callback implementation class {}.", new Object[]{((EventType)((Object)eventType)).name(), eventInfo == null ? "N/A" : eventInfo.toString(), System.currentTimeMillis(), this._helixManager, this._callbackImplClass.getClass().getCanonicalName()});
        if (eventType == EventType.ON_PAUSE) {
            this.onPauseOperations.forEach(operation -> this.executeOperation(eventType, eventInfo, operation));
        } else if (eventType == EventType.ON_RESUME) {
            this.onResumeOperations.forEach(operation -> this.executeOperation(eventType, eventInfo, operation));
        }
    }

    private void executeOperation(Object eventType, Object eventInfo, Object operation) {
        Set<CloudEventCallbackProperty.HelixOperation> enabledHelixOperationSet = this._property.getEnabledHelixOperation();
        if (CloudEventCallbackProperty.HelixOperation.ENABLE_DISABLE_INSTANCE.equals(operation)) {
            if (enabledHelixOperationSet.contains((Object)CloudEventCallbackProperty.HelixOperation.ENABLE_DISABLE_INSTANCE)) {
                if (eventType == EventType.ON_PAUSE) {
                    this._callbackImplClass.disableInstance(this._helixManager, eventInfo);
                } else {
                    this._callbackImplClass.enableInstance(this._helixManager, eventInfo);
                }
            }
        } else if (CloudEventCallbackProperty.HelixOperation.MAINTENANCE_MODE.equals(operation)) {
            if (enabledHelixOperationSet.contains((Object)CloudEventCallbackProperty.HelixOperation.MAINTENANCE_MODE)) {
                if (eventType == EventType.ON_PAUSE) {
                    this._callbackImplClass.enterMaintenanceMode(this._helixManager, eventInfo);
                } else {
                    this._callbackImplClass.exitMaintenanceMode(this._helixManager, eventInfo);
                }
            }
        } else if (operation instanceof CloudEventCallbackProperty.UserDefinedCallbackType) {
            BiConsumer<HelixManager, Object> callback = this._property.getUserDefinedCallbackMap().get(operation);
            if (callback != null) {
                callback.accept(this._helixManager, eventInfo);
            }
        } else {
            throw new HelixException("Unknown category of cloud event operation " + operation.toString());
        }
    }

    @Override
    public CloudEventListener.ListenerType getListenerType() {
        return CloudEventListener.ListenerType.UNORDERED;
    }

    private DefaultCloudEventCallbackImpl loadCloudEventCallbackImplClass(String implClassName) throws IllegalAccessException, InstantiationException {
        DefaultCloudEventCallbackImpl implClass;
        try {
            LOG.info("Loading class: " + implClassName);
            implClass = (DefaultCloudEventCallbackImpl)HelixUtil.loadClass(this.getClass(), implClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            implClass = new DefaultCloudEventCallbackImpl();
            LOG.error("No cloud event callback implementation class found for: {}. message: {}. Using default callback impl class instead.", (Object)implClassName, (Object)e.getMessage());
        }
        LOG.info("Using {} as cloud event callback impl class.", (Object)implClass.getClass().getCanonicalName());
        return implClass;
    }

    public static enum EventType {
        ON_PAUSE,
        ON_RESUME;

    }
}

