/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;

final class JettyThreadPool {
    private JettyThreadPool() {
    }

    static QueuedThreadPool create(ServerProperties.Jetty.Threads properties) {
        BlockingQueue<Runnable> queue = JettyThreadPool.determineBlockingQueue(properties.getMaxQueueCapacity());
        int maxThreadCount = properties.getMax() > 0 ? properties.getMax() : 200;
        int minThreadCount = properties.getMin() > 0 ? properties.getMin() : 8;
        int threadIdleTimeout = properties.getIdleTimeout() != null ? (int)properties.getIdleTimeout().toMillis() : 60000;
        return new QueuedThreadPool(maxThreadCount, minThreadCount, threadIdleTimeout, queue);
    }

    private static BlockingQueue<Runnable> determineBlockingQueue(Integer maxQueueCapacity) {
        if (maxQueueCapacity == null) {
            return null;
        }
        if (maxQueueCapacity == 0) {
            return new SynchronousQueue<Runnable>();
        }
        return new BlockingArrayQueue(maxQueueCapacity.intValue());
    }
}

