/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.convert.DB2J;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbSQLXML;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class DmdbSQLInput
implements SQLInput {
    private Object[] m_attribs;
    private int index = 0;
    private boolean isNull = false;
    private Map map;

    public DmdbSQLInput(Map map, Object[] objectArray) {
        this.m_attribs = objectArray;
        this.index = 0;
        this.isNull = false;
        this.map = map;
    }

    @Override
    public String readString() {
        String string;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
            string = null;
        } else {
            this.isNull = false;
            if (object instanceof Clob || object instanceof Blob || object instanceof byte[]) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            string = object.toString();
        }
        return string;
    }

    @Override
    public boolean readBoolean() {
        boolean bl;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
            bl = false;
        } else {
            this.isNull = false;
            bl = (Boolean)object;
        }
        return bl;
    }

    @Override
    public byte readByte() {
        byte by = 0;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            by = (Byte)object;
        }
        return by;
    }

    @Override
    public short readShort() {
        short s2 = 0;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(object instanceof Number) && !(object instanceof String)) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            s2 = Short.parseShort(object.toString());
        }
        return s2;
    }

    @Override
    public int readInt() {
        int n2 = 0;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(object instanceof Number) && !(object instanceof String)) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            n2 = Integer.parseInt(object.toString());
        }
        return n2;
    }

    @Override
    public long readLong() {
        long l2 = 0L;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(object instanceof Number) && !(object instanceof String)) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            l2 = Long.parseLong(object.toString());
        }
        return l2;
    }

    @Override
    public float readFloat() {
        float f2 = 0.0f;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(object instanceof Number) && !(object instanceof String)) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            f2 = Float.parseFloat(object.toString());
        }
        return f2;
    }

    @Override
    public double readDouble() {
        double d2 = 0.0;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (!(object instanceof Number) && !(object instanceof String)) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
            d2 = Double.parseDouble(object.toString());
        }
        return d2;
    }

    @Override
    public BigDecimal readBigDecimal() {
        BigDecimal bigDecimal = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (object instanceof BigDecimal) {
                bigDecimal = (BigDecimal)object;
            } else {
                if (!(object instanceof Number) && !(object instanceof String)) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
                bigDecimal = new BigDecimal(object.toString());
            }
        }
        return bigDecimal;
    }

    @Override
    public byte[] readBytes() {
        byte[] byArray = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            byArray = (byte[])object;
        }
        return byArray;
    }

    @Override
    public Date readDate() {
        Date date = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            date = (Date)object;
        }
        return date;
    }

    @Override
    public Time readTime() {
        Time time = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            time = (Time)object;
        }
        return time;
    }

    @Override
    public Timestamp readTimestamp() {
        Timestamp timestamp = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            timestamp = (Timestamp)object;
        }
        return timestamp;
    }

    @Override
    public Reader readCharacterStream() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public InputStream readAsciiStream() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public InputStream readBinaryStream() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object readObject() {
        Object object = null;
        this.checkIndex(this.index);
        Object object2 = this.m_attribs[this.index];
        ++this.index;
        if (object2 == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            if (object2 instanceof Struct) {
                Struct struct = (Struct)object2;
                object = DB2J.toSQLData(struct, this.map);
            } else {
                object = object2;
            }
        }
        return object;
    }

    @Override
    public Ref readRef() {
        Object object = this.readObject();
        if (object == null) {
            return null;
        }
        if (object instanceof SQLData || object instanceof Struct) {
            DmdbRef dmdbRef = new DmdbRef(object);
            return dmdbRef;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Blob readBlob() {
        Blob blob = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            blob = (Blob)object;
        }
        return blob;
    }

    @Override
    public Clob readClob() {
        Clob clob = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            clob = (Clob)object;
        }
        return clob;
    }

    @Override
    public Array readArray() {
        Array array = null;
        this.checkIndex(this.index);
        Object object = this.m_attribs[this.index];
        ++this.index;
        if (object == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            array = (Array)object;
        }
        return array;
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }

    @Override
    public URL readURL() {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    private void checkIndex(int n2) {
        if (n2 < 0 || n2 >= this.m_attribs.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    @Override
    public NClob readNClob() {
        return (NClob)this.readClob();
    }

    @Override
    public String readNString() {
        return this.readString();
    }

    @Override
    public SQLXML readSQLXML() {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        DmdbSQLXML dmdbSQLXML = new DmdbSQLXML();
        dmdbSQLXML.setString(string);
        return dmdbSQLXML;
    }

    @Override
    public RowId readRowId() {
        return (RowId)this.readObject();
    }
}

