/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.fldr.FldrResultSet$1;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class FldrResultSet
extends DmdbResultSet {
    private LinkedBlockingQueue rsQueue;
    private int rsCount = 0;
    private List rsList;
    private DmdbResultSet rRs;

    FldrResultSet(DmdbStatement dmdbStatement) {
        super(dmdbStatement, null, null);
        this.rsCount = dmdbStatement.fldrInfo.getFldrStmtSize();
        this.rsQueue = new LinkedBlockingQueue(this.rsCount);
        this.rsList = new ArrayList(this.rsCount);
    }

    public void init() {
        if (this.rsCount > 0) {
            this.rRs = this.takeRs();
        }
    }

    public void putRs(Object object) {
        try {
            this.rsQueue.put(object);
        }
        catch (Exception exception) {}
    }

    public DmdbResultSet takeRs() {
        Object var1_1 = null;
        try {
            var1_1 = this.rsQueue.take();
        }
        catch (Exception exception) {}
        if (var1_1 instanceof SQLException) {
            throw (SQLException)var1_1;
        }
        return var1_1;
    }

    public synchronized void registRs(DmdbResultSet dmdbResultSet) {
        this.rsList.add(dmdbResultSet);
    }

    public DmdbResultSet getRealRs() {
        return this.rRs;
    }

    @Override
    public boolean do_next() {
        if (this.rsCount == 0) {
            return false;
        }
        if (this.rRs == null) {
            this.rRs = this.takeRs();
        }
        if (FldrResultSet.isFinish(this.rRs)) {
            --this.rsCount;
            if (this.rsCount == 0) {
                return false;
            }
            this.rRs = null;
            return this.do_next();
        }
        if (FldrResultSet.needFetchData(this.rRs)) {
            this.fetchData(this.rRs);
            this.rRs = null;
            return this.do_next();
        }
        return FldrResultSet.nextForFldr(this.rRs);
    }

    private void fetchData(DmdbResultSet dmdbResultSet) {
        this.statement.connection.fldrInfo.fldrExecutor.execute(new FldrResultSet$1(this, dmdbResultSet));
    }

    @Override
    public void do_close() {
        for (ResultSet resultSet : this.rsList) {
            resultSet.close();
        }
    }

    @Override
    public SQLWarning do_getWarnings() {
        SQLWarning sQLWarning = null;
        for (ResultSet resultSet : this.rsList) {
            if (resultSet.getWarnings() == null) continue;
            if (sQLWarning == null) {
                sQLWarning = resultSet.getWarnings();
                continue;
            }
            sQLWarning.setNextWarning(resultSet.getWarnings());
            sQLWarning = resultSet.getWarnings();
            while (sQLWarning.getNextWarning() != null) {
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
        return sQLWarning;
    }

    @Override
    public void do_clearWarnings() {
        for (ResultSet resultSet : this.rsList) {
            resultSet.clearWarnings();
        }
    }

    public static boolean isFinish(DmdbResultSet dmdbResultSet) {
        return dmdbResultSet.currentPos >= dmdbResultSet.totalRowCount - 1L;
    }

    public static boolean needFetchData(DmdbResultSet dmdbResultSet) {
        if (FldrResultSet.isFinish(dmdbResultSet)) {
            return false;
        }
        return dmdbResultSet.currentPos >= dmdbResultSet.datasStartPos + (long)dmdbResultSet.datas.length - 1L;
    }

    public static boolean nextForFldr(DmdbResultSet dmdbResultSet) {
        dmdbResultSet.checkClosed();
        if (dmdbResultSet.totalRowCount == 0L) {
            return false;
        }
        if (dmdbResultSet.currentPos >= dmdbResultSet.totalRowCount) {
            return false;
        }
        if (dmdbResultSet.currentPos == dmdbResultSet.totalRowCount - 1L) {
            ++dmdbResultSet.currentPos;
            ++dmdbResultSet.datasOffset;
            return false;
        }
        if (dmdbResultSet.currentPos + 1L < dmdbResultSet.datasStartPos || dmdbResultSet.currentPos + 1L >= dmdbResultSet.datasStartPos + (long)dmdbResultSet.datas.length) {
            ++dmdbResultSet.currentPos;
            ++dmdbResultSet.datasOffset;
            return false;
        }
        ++dmdbResultSet.datasOffset;
        ++dmdbResultSet.currentPos;
        return true;
    }
}

