/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.client;

import java.io.IOException;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiHandlerManager;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.client.UdpConnection;
import org.apache.hertzbeat.collector.collect.ipmi2.client.handler.IpmiHandler;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.CloseSessionRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.CloseSessionResponse;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;

public class IpmiConnection
implements AutoCloseable {
    IpmiSession session;
    UdpConnection udpConnection;
    IpmiHandlerManager handlerManager = new IpmiHandlerManager();
    private volatile boolean active = true;

    IpmiConnection(IpmiSession session, UdpConnection udpConnection) {
        this.session = session;
        this.udpConnection = udpConnection;
    }

    public void getResource(CollectRep.MetricsData.Builder builder, Metrics metrics) throws IOException {
        IpmiHandler handler = this.handlerManager.getHandler(metrics.getName());
        if (handler == null) {
            throw new RuntimeException("no handler for " + metrics.getIpmi().getType());
        }
        handler.handler(this.session, this.udpConnection, builder, metrics);
    }

    @Override
    public void close() throws IOException {
        this.udpConnection.get(this.session, new CloseSessionRequest(this.session.getSystemSessionId()), CloseSessionResponse.class);
        this.udpConnection.close();
        this.session = null;
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }
}

