/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiChannelPrivilegeLevel;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.IpmiNetworkFunctionCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.IpmiRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.IpmiResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.chassis.GetChassisStatusRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.chassis.GetChassisStatusResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.CloseSessionRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.CloseSessionResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.GetChannelAuthenticationCapabilitiesRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.messaging.GetChannelAuthenticationCapabilitiesResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSdrRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSdrResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSensorReadingRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.GetSensorReadingResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.ReserveSdrRepositoryRequest;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.command.sdr.ReserveSdrRepositoryResponse;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiCommandName implements IpmiCode.Code
{
    GetChassisStatus("Get Chassis Status", IpmiNetworkFunctionCode.Chassis, 1, IpmiChannelPrivilegeLevel.User, GetChassisStatusRequest.class, GetChassisStatusResponse.class),
    GetChannelAuthenticationCapabilities("Get Channel Authentication Capabilities", IpmiNetworkFunctionCode.App, 56, IpmiChannelPrivilegeLevel.User, GetChannelAuthenticationCapabilitiesRequest.class, GetChannelAuthenticationCapabilitiesResponse.class),
    CloseSession("Close Session", IpmiNetworkFunctionCode.App, 60, IpmiChannelPrivilegeLevel.Callback, CloseSessionRequest.class, CloseSessionResponse.class),
    ReserveSdrRepository("Reserve SDR Repository", IpmiNetworkFunctionCode.Storage, 34, IpmiChannelPrivilegeLevel.User, ReserveSdrRepositoryRequest.class, ReserveSdrRepositoryResponse.class),
    GetSdr("Get SDR", IpmiNetworkFunctionCode.Storage, 35, IpmiChannelPrivilegeLevel.User, GetSdrRequest.class, GetSdrResponse.class),
    GetSensorReading("Get Sensor Reading", IpmiNetworkFunctionCode.Sensor_Event, 45, IpmiChannelPrivilegeLevel.User, GetSensorReadingRequest.class, GetSensorReadingResponse.class);

    private final String name;
    private final IpmiNetworkFunctionCode networkFunction;
    private final byte code;
    private final IpmiChannelPrivilegeLevel privilegeLevel;
    private final Class<? extends IpmiRequest> requestType;
    private final Class<? extends IpmiResponse> responseType;

    private IpmiCommandName(String name, IpmiNetworkFunctionCode networkFunction, int code, IpmiChannelPrivilegeLevel privilegeLevel, Class<? extends IpmiRequest> requestType, Class<? extends IpmiResponse> responseType) {
        this.name = name;
        this.networkFunction = networkFunction;
        this.code = ByteConvertUtils.checkCastByte(code);
        this.privilegeLevel = privilegeLevel;
        this.requestType = requestType;
        this.responseType = responseType;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    public IpmiNetworkFunctionCode getNetworkFunction() {
        return this.networkFunction;
    }

    public static IpmiCommandName fromNetFunctionAndCode(IpmiNetworkFunctionCode networkFunction, byte code) {
        for (IpmiCommandName command : IpmiCommandName.values()) {
            if (command.networkFunction != networkFunction || command.code != code) continue;
            return command;
        }
        throw new UnsupportedOperationException("Unsupported command: " + networkFunction + " " + ByteConvertUtils.byteToInt(code));
    }

    public static IpmiResponse getResponseByRequest(Class<? extends IpmiRequest> request) {
        for (IpmiCommandName command : IpmiCommandName.values()) {
            IpmiResponse response;
            if (!command.requestType.isInstance(request) || !command.responseType.isInstance(response = command.newIpmiResponse())) continue;
            return response;
        }
        throw new UnsupportedOperationException("Unsupported request: " + request);
    }

    public IpmiResponse newIpmiResponse() {
        try {
            return this.responseType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public IpmiRequest newIpmiRequest() {
        try {
            return this.requestType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

