/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginContext {
    private static final Logger log = LoggerFactory.getLogger(PluginContext.class);
    private List<Configmap> params;
    private ParamHolder paramHolder;

    public ParamHolder param() {
        if (this.paramHolder == null) {
            this.paramHolder = new ParamHolder(this.params);
        }
        return this.paramHolder;
    }

    PluginContext(List<Configmap> params, ParamHolder paramHolder) {
        this.params = params;
        this.paramHolder = paramHolder;
    }

    public static PluginContextBuilder builder() {
        return new PluginContextBuilder();
    }

    public static class ParamHolder {
        private final Map<String, Configmap> paramsMap;

        public ParamHolder(List<Configmap> params) {
            this.paramsMap = params == null ? Collections.emptyMap() : params.stream().collect(Collectors.toMap(Configmap::getKey, configmap -> configmap));
        }

        public String getString(String paramName, String defaultValue) {
            Configmap configmap = this.paramsMap.get(paramName);
            if (configmap == null) {
                return defaultValue;
            }
            return Optional.ofNullable(configmap.getValue()).map(Object::toString).orElse(defaultValue);
        }

        public Integer getInteger(String paramName, Integer defaultValue) {
            Configmap configmap = this.paramsMap.get(paramName);
            if (configmap == null) {
                return defaultValue;
            }
            try {
                return Optional.ofNullable(configmap.getValue()).map(v -> Integer.parseInt(v.toString())).orElse(defaultValue);
            }
            catch (Exception e) {
                log.warn("int parameter type conversion error paramName:{} value:{} defaultValue:{}", new Object[]{paramName, configmap.getValue(), defaultValue});
                return defaultValue;
            }
        }

        public Boolean getBoolean(String paramName, Boolean defaultValue) {
            Configmap configmap = this.paramsMap.get(paramName);
            if (configmap == null) {
                return defaultValue;
            }
            try {
                return Optional.ofNullable(configmap.getValue()).map(v -> Boolean.parseBoolean(v.toString())).orElse(defaultValue);
            }
            catch (Exception e) {
                log.warn("boolean parameter type conversion error paramName:{} value:{} defaultValue:{}", new Object[]{paramName, configmap.getValue(), defaultValue});
                return defaultValue;
            }
        }

        public Long getLong(String paramName, Long defaultValue) {
            Configmap configmap = this.paramsMap.get(paramName);
            if (configmap == null) {
                return defaultValue;
            }
            try {
                return Optional.ofNullable(configmap.getValue()).map(v -> Long.parseLong(v.toString())).orElse(defaultValue);
            }
            catch (Exception e) {
                log.warn("long parameter type conversion error paramName:{} value:{} defaultValue:{}", new Object[]{paramName, configmap.getValue(), defaultValue});
                return defaultValue;
            }
        }

        public List<Configmap> allParams() {
            return this.paramsMap.values().stream().map(SerializationUtils::clone).collect(Collectors.toList());
        }
    }

    public static class PluginContextBuilder {
        private List<Configmap> params;
        private ParamHolder paramHolder;

        PluginContextBuilder() {
        }

        public PluginContextBuilder params(List<Configmap> params) {
            this.params = params;
            return this;
        }

        public PluginContextBuilder paramHolder(ParamHolder paramHolder) {
            this.paramHolder = paramHolder;
            return this;
        }

        public PluginContext build() {
            return new PluginContext(this.params, this.paramHolder);
        }

        public String toString() {
            return "PluginContext.PluginContextBuilder(params=" + this.params + ", paramHolder=" + this.paramHolder + ")";
        }
    }
}

