/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import javax.naming.AuthenticationException;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.springframework.http.ResponseEntity;

public class ResponseUtil {
    public static <T, E extends Exception> ResponseEntity<Message<T>> handle(Supplier<T, E> supplier) {
        try {
            T result = supplier.get();
            return ResponseEntity.ok(Message.success(result));
        }
        catch (Exception e) {
            byte err = 15;
            if (e.getClass().equals(AuthenticationException.class)) {
                err = 5;
            }
            return ResponseEntity.ok(Message.fail(err, e.getMessage()));
        }
    }

    public static <T, E extends Exception> ResponseEntity<Message<T>> handle(Runnable runner) {
        try {
            runner.run();
            return ResponseEntity.ok(Message.success());
        }
        catch (Exception e) {
            byte err = 15;
            if (e.getClass().equals(AuthenticationException.class)) {
                err = 5;
            }
            return ResponseEntity.ok(Message.fail(err, e.getMessage()));
        }
    }

    public static interface Supplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface Runnable {
        public void run() throws Exception;
    }
}

