/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import com.facebook.thrift.TByteArrayOutputStream;
import com.facebook.thrift.transport.TMemoryInputTransport;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.transport.TTransportFactory;

public class TFramedTransport
extends TTransport {
    protected static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    private int maxLength_;
    protected TTransport transport_ = null;
    protected final TByteArrayOutputStream writeBuffer_ = new TByteArrayOutputStream(1024);
    protected TMemoryInputTransport readBuffer_ = new TMemoryInputTransport(new byte[0]);
    private final byte[] i32buf = new byte[4];

    public TFramedTransport(TTransport transport, int maxLength) {
        this.transport_ = transport;
        this.maxLength_ = maxLength;
    }

    public TFramedTransport(TTransport transport) {
        this.transport_ = transport;
        this.maxLength_ = Integer.MAX_VALUE;
    }

    @Override
    public void open() throws TTransportException {
        this.transport_.open();
    }

    @Override
    public boolean isOpen() {
        return this.transport_.isOpen();
    }

    @Override
    public void close() {
        this.transport_.close();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int got = this.readBuffer_.read(buf, off, len);
        if (got > 0) {
            return got;
        }
        this.readFrame();
        return this.readBuffer_.read(buf, off, len);
    }

    @Override
    public byte[] getBuffer() {
        return this.readBuffer_.getBuffer();
    }

    @Override
    public int getBufferPosition() {
        return this.readBuffer_.getBufferPosition();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return this.readBuffer_.getBytesRemainingInBuffer();
    }

    @Override
    public void consumeBuffer(int len) {
        this.readBuffer_.consumeBuffer(len);
    }

    protected void readFrame() throws TTransportException {
        this.transport_.readAll(this.i32buf, 0, 4);
        int size = TFramedTransport.decodeWord(this.i32buf);
        if (size < 0) {
            throw new TTransportException(String.format("Read a negative frame size (%d)!", size));
        }
        if (size > this.maxLength_) {
            throw new TTransportException(String.format("Frame size (%d) larger than max length (%d)!", size, this.maxLength_));
        }
        byte[] buff = new byte[size];
        this.transport_.readAll(buff, 0, size);
        this.readBuffer_.reset(buff);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.writeBuffer_.write(buf, off, len);
    }

    @Override
    public void flush() throws TTransportException {
        byte[] buf = this.writeBuffer_.get();
        int len = this.writeBuffer_.len();
        this.writeBuffer_.reset();
        TFramedTransport.encodeWord(len, this.i32buf);
        this.transport_.write(this.i32buf, 0, 4);
        this.transport_.write(buf, 0, len);
        this.transport_.flush();
    }

    public static final void encodeWord(int frameSize, byte[] buf) {
        buf[0] = (byte)(0xFF & frameSize >> 24);
        buf[1] = (byte)(0xFF & frameSize >> 16);
        buf[2] = (byte)(0xFF & frameSize >> 8);
        buf[3] = (byte)(0xFF & frameSize);
    }

    public static final int decodeWord(byte[] buf) {
        return TFramedTransport.decodeWord(buf, 0);
    }

    public static final int decodeWord(byte[] buf, int off) {
        return (buf[0 + off] & 0xFF) << 24 | (buf[1 + off] & 0xFF) << 16 | (buf[2 + off] & 0xFF) << 8 | buf[3 + off] & 0xFF;
    }

    public static final short decodeShort(byte[] buf) {
        return TFramedTransport.decodeShort(buf, 0);
    }

    public static final short decodeShort(byte[] buf, int off) {
        return (short)((buf[0 + off] & 0xFF) << 8 | buf[1 + off] & 0xFF);
    }

    public static final void encodeShort(int value, byte[] buf) {
        buf[0] = (byte)(0xFF & value >> 8);
        buf[1] = (byte)(0xFF & value);
    }

    public static class Factory
    extends TTransportFactory {
        private int maxLength_;

        public Factory() {
            this.maxLength_ = Integer.MAX_VALUE;
        }

        public Factory(int maxLength) {
            this.maxLength_ = maxLength;
        }

        @Override
        public TTransport getTransport(TTransport base) {
            return new TFramedTransport(base, this.maxLength_);
        }
    }
}

