/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Time;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class TimeUtil {
    public static DateTime datetimeConvertWithTimezone(DateTime dateTime, int timezoneOffset) {
        LocalDateTime localDateTime = LocalDateTime.of((int)dateTime.getYear(), dateTime.getMonth(), (int)dateTime.getDay(), (int)dateTime.getHour(), (int)dateTime.getMinute(), (int)dateTime.getSec(), dateTime.getMicrosec() * 1000);
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timezoneOffset);
        OffsetDateTime utcOffsetDateTime = localDateTime.atOffset(ZoneOffset.UTC);
        OffsetDateTime localOffsetDateTime = utcOffsetDateTime.withOffsetSameInstant(zoneOffset);
        return new DateTime((short)localOffsetDateTime.getYear(), (byte)localOffsetDateTime.getMonth().getValue(), (byte)localOffsetDateTime.getDayOfMonth(), (byte)localOffsetDateTime.getHour(), (byte)localOffsetDateTime.getMinute(), (byte)localOffsetDateTime.getSecond(), localOffsetDateTime.getNano() / 1000);
    }

    public static Time timeConvertWithTimezone(Time time, int timezoneOffset) {
        DateTime dateTime = new DateTime(0, 1, 1, time.getHour(), time.getMinute(), time.getSec(), time.getMicrosec());
        DateTime localDateTime = TimeUtil.datetimeConvertWithTimezone(dateTime, timezoneOffset);
        return new Time(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSec(), localDateTime.getMicrosec());
    }
}

