/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.Time;
import com.vesoft.nebula.client.graph.data.BaseDataObject;
import com.vesoft.nebula.client.graph.data.TimeUtil;
import java.util.Objects;

public class TimeWrapper
extends BaseDataObject {
    private final Time time;

    public TimeWrapper(Time time) {
        this.time = time;
    }

    public byte getHour() {
        return this.time.getHour();
    }

    public byte getMinute() {
        return this.time.getMinute();
    }

    public byte getSecond() {
        return this.time.getSec();
    }

    public int getMicrosec() {
        return this.time.getMicrosec();
    }

    public Time getLocalTime() {
        return TimeUtil.timeConvertWithTimezone(this.time, this.getTimezoneOffset());
    }

    public Time getTimeWithTimezoneOffset(int timezoneOffset) {
        return TimeUtil.timeConvertWithTimezone(this.time, timezoneOffset);
    }

    public String getLocalTimeStr() {
        Time localTime = TimeUtil.timeConvertWithTimezone(this.time, this.getTimezoneOffset());
        return String.format("%02d:%02d:%02d.%06d", localTime.hour, localTime.minute, localTime.sec, localTime.microsec);
    }

    public String getUTCTimeStr() {
        return String.format("%02d:%02d:%02d.%06d", this.time.hour, this.time.minute, this.time.sec, this.time.microsec);
    }

    public String toString() {
        return String.format("utc time: %02d:%02d:%02d.%06d, timezoneOffset: %d", this.time.hour, this.time.minute, this.time.sec, this.time.microsec, this.getTimezoneOffset());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWrapper that = (TimeWrapper)o;
        return this.time.hour == that.getHour() && this.time.minute == that.getMinute() && this.time.sec == this.time.getSec() && this.time.microsec == this.time.getMicrosec();
    }

    public int hashCode() {
        return Objects.hash(this.time);
    }
}

