/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class EnumSetOutput<K, V, E extends Enum<E>>
extends CommandOutput<K, V, Set<E>> {
    private boolean initialized;
    private final Class<E> enumClass;
    private final UnaryOperator<String> enumValuePreprocessor;
    private final Function<String, E> onUnknownValue;

    public EnumSetOutput(RedisCodec<K, V> codec, Class<E> enumClass, UnaryOperator<String> enumValuePreprocessor, Function<String, E> onUnknownValue) {
        super(codec, Collections.emptySet());
        this.enumClass = enumClass;
        this.enumValuePreprocessor = enumValuePreprocessor;
        this.onUnknownValue = onUnknownValue;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes == null) {
            return;
        }
        E enumConstant = this.resolve((String)this.enumValuePreprocessor.apply(this.decodeAscii(bytes)));
        if (enumConstant == null) {
            return;
        }
        ((Set)this.output).add(enumConstant);
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = EnumSet.noneOf(this.enumClass);
            this.initialized = true;
        }
    }

    private E resolve(String value) {
        try {
            return Enum.valueOf(this.enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return (E)((Enum)this.onUnknownValue.apply(value));
        }
    }
}

