/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.LettuceObservationContext;
import io.lettuce.core.tracing.LettuceObservationConvention;
import io.lettuce.core.tracing.RedisObservation;
import io.lettuce.core.tracing.SocketAddressEndpoint;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.net.InetSocketAddress;
import java.util.Locale;

public final class DefaultLettuceObservationConvention
implements LettuceObservationConvention {
    private final boolean includeCommandArgsInSpanTags;

    DefaultLettuceObservationConvention(boolean includeCommandArgsInSpanTags) {
        this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
    }

    public KeyValues getLowCardinalityKeyValues(LettuceObservationContext context) {
        Tracing.Endpoint ep = context.getRequiredEndpoint();
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{RedisObservation.LowCardinalityCommandKeyNames.DATABASE_SYSTEM.withValue("redis"), RedisObservation.LowCardinalityCommandKeyNames.REDIS_COMMAND.withValue(context.getRequiredCommand().getType().name())});
        if (ep instanceof SocketAddressEndpoint) {
            SocketAddressEndpoint endpoint = (SocketAddressEndpoint)ep;
            if (endpoint.getSocketAddress() instanceof InetSocketAddress) {
                InetSocketAddress inet = (InetSocketAddress)endpoint.getSocketAddress();
                keyValues = keyValues.and((Iterable)KeyValues.of((KeyValue[])new KeyValue[]{RedisObservation.LowCardinalityCommandKeyNames.NET_SOCK_PEER_ADDR.withValue(inet.getHostString()), RedisObservation.LowCardinalityCommandKeyNames.NET_SOCK_PEER_PORT.withValue("" + inet.getPort()), RedisObservation.LowCardinalityCommandKeyNames.NET_TRANSPORT.withValue("IP.TCP")}));
            } else {
                keyValues = keyValues.and((Iterable)KeyValues.of((KeyValue[])new KeyValue[]{RedisObservation.LowCardinalityCommandKeyNames.NET_PEER_NAME.withValue(endpoint.toString()), RedisObservation.LowCardinalityCommandKeyNames.NET_TRANSPORT.withValue("Unix")}));
            }
        }
        return keyValues;
    }

    public KeyValues getHighCardinalityKeyValues(LettuceObservationContext context) {
        RedisCommand<?, ?, ?> command = context.getRequiredCommand();
        if (this.includeCommandArgsInSpanTags && command.getArgs() != null) {
            return KeyValues.of((KeyValue[])new KeyValue[]{RedisObservation.HighCardinalityCommandKeyNames.STATEMENT.withValue(command.getType().name() + " " + command.getArgs().toCommandString())});
        }
        return KeyValues.empty();
    }

    public String getContextualName(LettuceObservationContext context) {
        return context.getRequiredCommand().getType().name().toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean includeCommandArgsInSpanTags() {
        return this.includeCommandArgsInSpanTags;
    }
}

