/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiElement;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, AnsiElement> ELEMENTS;
    private static final Map<Integer, AnsiElement> LEVELS;

    protected String transform(ILoggingEvent event, String in) {
        AnsiElement color = ELEMENTS.get(this.getFirstOption());
        if (color == null) {
            color = LEVELS.get(event.getLevel().toInteger());
            color = color != null ? color : AnsiColor.GREEN;
        }
        return this.toAnsiString(in, color);
    }

    protected String toAnsiString(String in, AnsiElement element) {
        return AnsiOutput.toString(element, in);
    }

    static String getName(AnsiElement element) {
        return ELEMENTS.entrySet().stream().filter(entry -> ((AnsiElement)entry.getValue()).equals(element)).map(Map.Entry::getKey).findFirst().orElseThrow();
    }

    static {
        HashMap<String, AnsiStyle> ansiElements = new HashMap<String, AnsiStyle>();
        Arrays.stream(AnsiColor.values()).filter(color -> color != AnsiColor.DEFAULT).forEach(color -> ansiElements.put(color.name().toLowerCase(Locale.ROOT), (AnsiStyle)color));
        ansiElements.put("faint", AnsiStyle.FAINT);
        ELEMENTS = Collections.unmodifiableMap(ansiElements);
        HashMap<Integer, AnsiColor> ansiLevels = new HashMap<Integer, AnsiColor>();
        ansiLevels.put(Level.ERROR_INTEGER, AnsiColor.RED);
        ansiLevels.put(Level.WARN_INTEGER, AnsiColor.YELLOW);
        LEVELS = Collections.unmodifiableMap(ansiLevels);
    }
}

