/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11AccessNetworkType
extends NamedNumber<Byte, Dot11AccessNetworkType> {
    private static final long serialVersionUID = 446760220104978318L;
    public static final Dot11AccessNetworkType PRIVATE_NETWORK = new Dot11AccessNetworkType((byte)0, "Private network");
    public static final Dot11AccessNetworkType PRIVATE_NETWORK_WITH_GUEST_ACCESS = new Dot11AccessNetworkType((byte)1, "Private network with guest access");
    public static final Dot11AccessNetworkType CHARGEABLE_PUBLIC_NETWORK = new Dot11AccessNetworkType((byte)2, "Chargeable public network");
    public static final Dot11AccessNetworkType FREE_PUBLIC_NETWORK = new Dot11AccessNetworkType((byte)3, "Free public network");
    public static final Dot11AccessNetworkType PERSONAL_DEVICE_NETWORK = new Dot11AccessNetworkType((byte)4, "Personal device network");
    public static final Dot11AccessNetworkType EMERGENCY_SERVICES_ONLY_NETWORK = new Dot11AccessNetworkType((byte)5, "Emergency services only network");
    public static final Dot11AccessNetworkType TEST_OR_EXPERIMENTAL = new Dot11AccessNetworkType((byte)14, "Test or experimental");
    public static final Dot11AccessNetworkType WILDCARD = new Dot11AccessNetworkType((byte)15, "Wildcard");
    private static final Map<Byte, Dot11AccessNetworkType> registry = new HashMap<Byte, Dot11AccessNetworkType>();

    public Dot11AccessNetworkType(Byte value, String name) {
        super(value, name);
        if ((value & 0xF0) != 0) {
            throw new IllegalArgumentException("(value & 0xF0) must be 0. value: " + value);
        }
    }

    public static Dot11AccessNetworkType getInstance(Byte value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new Dot11AccessNetworkType(value, "unknown");
    }

    public static Dot11AccessNetworkType register(Dot11AccessNetworkType number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11AccessNetworkType o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)PRIVATE_NETWORK.value(), PRIVATE_NETWORK);
        registry.put((Byte)PRIVATE_NETWORK_WITH_GUEST_ACCESS.value(), PRIVATE_NETWORK_WITH_GUEST_ACCESS);
        registry.put((Byte)CHARGEABLE_PUBLIC_NETWORK.value(), CHARGEABLE_PUBLIC_NETWORK);
        registry.put((Byte)FREE_PUBLIC_NETWORK.value(), FREE_PUBLIC_NETWORK);
        registry.put((Byte)PERSONAL_DEVICE_NETWORK.value(), PERSONAL_DEVICE_NETWORK);
        registry.put((Byte)EMERGENCY_SERVICES_ONLY_NETWORK.value(), EMERGENCY_SERVICES_ONLY_NETWORK);
        registry.put((Byte)TEST_OR_EXPERIMENTAL.value(), TEST_OR_EXPERIMENTAL);
        registry.put((Byte)WILDCARD.value(), WILDCARD);
    }
}

