/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheusmetrics;

import io.micrometer.prometheusmetrics.ExemplarSamplerFactory;
import io.prometheus.metrics.config.ExemplarsProperties;
import io.prometheus.metrics.core.exemplars.ExemplarSampler;
import io.prometheus.metrics.core.exemplars.ExemplarSamplerConfig;
import io.prometheus.metrics.tracer.common.SpanContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class DefaultExemplarSamplerFactory
implements ExemplarSamplerFactory {
    private final ExemplarsProperties exemplarsProperties;
    private final ConcurrentMap<Integer, ExemplarSamplerConfig> exemplarSamplerConfigsByNumberOfExemplars = new ConcurrentHashMap<Integer, ExemplarSamplerConfig>();
    private final ConcurrentMap<double[], ExemplarSamplerConfig> exemplarSamplerConfigsByHistogramUpperBounds = new ConcurrentHashMap<double[], ExemplarSamplerConfig>();
    private final SpanContext spanContext;

    DefaultExemplarSamplerFactory(SpanContext spanContext, ExemplarsProperties exemplarsProperties) {
        this.spanContext = spanContext;
        this.exemplarsProperties = exemplarsProperties;
    }

    @Override
    public ExemplarSampler createExemplarSampler(int numberOfExemplars) {
        ExemplarSamplerConfig config = this.exemplarSamplerConfigsByNumberOfExemplars.computeIfAbsent(numberOfExemplars, key -> new ExemplarSamplerConfig(this.exemplarsProperties, numberOfExemplars));
        return new ExemplarSampler(config, this.spanContext);
    }

    @Override
    public ExemplarSampler createExemplarSampler(double[] histogramUpperBounds) {
        ExemplarSamplerConfig config = this.exemplarSamplerConfigsByHistogramUpperBounds.computeIfAbsent(histogramUpperBounds, key -> new ExemplarSamplerConfig(this.exemplarsProperties, histogramUpperBounds));
        return new ExemplarSampler(config, this.spanContext);
    }
}

