/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.Utils;
import com.ecwid.consul.transport.DefaultHttpTransport;
import com.ecwid.consul.transport.DefaultHttpsTransport;
import com.ecwid.consul.transport.HttpRequest;
import com.ecwid.consul.transport.HttpResponse;
import com.ecwid.consul.transport.HttpTransport;
import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.Request;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.HttpClient;

public class ConsulRawClient {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8500;
    public static final String DEFAULT_PATH = "";
    private static final HttpTransport DEFAULT_HTTP_TRANSPORT = new DefaultHttpTransport();
    private final HttpTransport httpTransport;
    private final String agentAddress;

    public ConsulRawClient() {
        this(DEFAULT_HOST);
    }

    public ConsulRawClient(TLSConfig tlsConfig) {
        this(DEFAULT_HOST, tlsConfig);
    }

    public ConsulRawClient(String agentHost) {
        this(agentHost, 8500);
    }

    public ConsulRawClient(String agentHost, TLSConfig tlsConfig) {
        this(agentHost, 8500, tlsConfig);
    }

    public ConsulRawClient(String agentHost, int agentPort) {
        this(DEFAULT_HTTP_TRANSPORT, agentHost, agentPort, DEFAULT_PATH);
    }

    public ConsulRawClient(HttpClient httpClient) {
        this(DEFAULT_HOST, httpClient);
    }

    public ConsulRawClient(String agentHost, HttpClient httpClient) {
        this(new DefaultHttpTransport(httpClient), agentHost, 8500, DEFAULT_PATH);
    }

    public ConsulRawClient(String agentHost, int agentPort, HttpClient httpClient) {
        this(new DefaultHttpTransport(httpClient), agentHost, agentPort, DEFAULT_PATH);
    }

    public ConsulRawClient(String agentHost, int agentPort, TLSConfig tlsConfig) {
        this(new DefaultHttpsTransport(tlsConfig), agentHost, agentPort, DEFAULT_PATH);
    }

    public ConsulRawClient(HttpClient httpClient, String host, int port, String path) {
        this(new DefaultHttpTransport(httpClient), host, port, path);
    }

    ConsulRawClient(HttpTransport httpTransport, String agentHost, int agentPort, String path) {
        this.httpTransport = httpTransport;
        String agentHostLowercase = agentHost.toLowerCase();
        if (!agentHostLowercase.startsWith("https://") && !agentHostLowercase.startsWith("http://")) {
            agentHost = "http://" + agentHost;
        }
        this.agentAddress = Utils.assembleAgentAddress(agentHost, agentPort, path);
    }

    public HttpResponse makeGetRequest(String endpoint, UrlParameters ... urlParams) {
        return this.makeGetRequest(endpoint, Arrays.asList(urlParams));
    }

    public HttpResponse makeGetRequest(String endpoint, List<UrlParameters> urlParams) {
        String url = this.prepareUrl(this.agentAddress + endpoint);
        url = Utils.generateUrl(url, urlParams);
        HttpRequest request = HttpRequest.Builder.newBuilder().setUrl(url).build();
        return this.httpTransport.makeGetRequest(request);
    }

    public HttpResponse makeGetRequest(Request request) {
        String url = this.prepareUrl(this.agentAddress + request.getEndpoint());
        url = Utils.generateUrl(url, request.getUrlParameters());
        HttpRequest httpRequest = HttpRequest.Builder.newBuilder().setUrl(url).addHeaders(Utils.createTokenMap(request.getToken())).build();
        return this.httpTransport.makeGetRequest(httpRequest);
    }

    public HttpResponse makePutRequest(String endpoint, String content, UrlParameters ... urlParams) {
        String url = this.prepareUrl(this.agentAddress + endpoint);
        url = Utils.generateUrl(url, urlParams);
        HttpRequest request = HttpRequest.Builder.newBuilder().setUrl(url).setContent(content).build();
        return this.httpTransport.makePutRequest(request);
    }

    public HttpResponse makePutRequest(Request request) {
        String url = this.prepareUrl(this.agentAddress + request.getEndpoint());
        url = Utils.generateUrl(url, request.getUrlParameters());
        HttpRequest httpRequest = HttpRequest.Builder.newBuilder().setUrl(url).setBinaryContent(request.getBinaryContent()).addHeaders(Utils.createTokenMap(request.getToken())).build();
        return this.httpTransport.makePutRequest(httpRequest);
    }

    public HttpResponse makeDeleteRequest(Request request) {
        String url = this.prepareUrl(this.agentAddress + request.getEndpoint());
        url = Utils.generateUrl(url, request.getUrlParameters());
        HttpRequest httpRequest = HttpRequest.Builder.newBuilder().setUrl(url).addHeaders(Utils.createTokenMap(request.getToken())).build();
        return this.httpTransport.makeDeleteRequest(httpRequest);
    }

    private String prepareUrl(String url) {
        if (url.contains(" ")) {
            return Utils.encodeUrl(url);
        }
        return url;
    }

    static /* synthetic */ HttpTransport access$000() {
        return DEFAULT_HTTP_TRANSPORT;
    }

    public static final class Builder {
        private String agentHost = "localhost";
        private int agentPort = 8500;
        private String agentPath = "";
        private HttpTransport httpTransport = ConsulRawClient.access$000();

        public static Builder builder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setHost(String host) {
            this.agentHost = host;
            return this;
        }

        public Builder setPort(int port) {
            this.agentPort = port;
            return this;
        }

        public Builder setPath(String path) {
            this.agentPath = path;
            return this;
        }

        public Builder setTlsConfig(TLSConfig tlsConfig) {
            this.httpTransport = new DefaultHttpsTransport(tlsConfig);
            return this;
        }

        public Builder setHttpClient(HttpClient httpClient) {
            this.httpTransport = new DefaultHttpTransport(httpClient);
            return this;
        }

        public ConsulRawClient build() {
            return new ConsulRawClient(this.httpTransport, this.agentHost, this.agentPort, this.agentPath);
        }
    }
}

