/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.generation.ParseAssertException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderAssert<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderAssert.class);

    public T readAssertField(String logicalName, DataReader<T> dataReader, T expectedValue, WithReaderArgs ... readerArgs) throws ParseException {
        T assertValue;
        LOGGER.debug("reading field {}", (Object)logicalName);
        try {
            assertValue = dataReader.read(logicalName, readerArgs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseAssertException("Field: " + logicalName + ": Not enough data", e);
        }
        if (!Objects.equals(assertValue, expectedValue)) {
            throw new ParseAssertException("Field: " + logicalName + ": Actual value " + assertValue + " doesn't match expected " + expectedValue);
        }
        return assertValue;
    }
}

