/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.codegen.fields;

import java.math.BigInteger;
import org.apache.plc4x.java.spi.codegen.FieldCommons;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldReaderVirtual<T>
implements FieldCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldReaderVirtual.class);

    public T readVirtualField(String logicalName, Class<T> type, Object valueExpression, WithReaderArgs ... readerArgs) throws ParseException {
        LOGGER.debug("reading field {}", (Object)logicalName);
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return (T)((Boolean)valueExpression);
            }
            if (type == Byte.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                long longValue = valueExpressionNumber.longValue();
                if ((long)((byte)longValue) != longValue && longValue != 255L) {
                    throw new ArithmeticException("byte overflow");
                }
                return (T)Byte.valueOf(valueExpressionNumber.byteValue());
            }
            if (type == Short.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                long longValue = valueExpressionNumber.longValue();
                if ((long)((short)longValue) != longValue) {
                    throw new ArithmeticException("short overflow");
                }
                return (T)Short.valueOf(valueExpressionNumber.shortValue());
            }
            if (type == Integer.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                long longValue = valueExpressionNumber.longValue();
                if ((long)((int)longValue) != longValue) {
                    throw new ArithmeticException("integer overflow");
                }
                return (T)Integer.valueOf(valueExpressionNumber.intValue());
            }
            if (type == Long.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                return (T)Long.valueOf(valueExpressionNumber.longValue());
            }
            if (type == Character.TYPE) {
                return (T)Character.valueOf(((Character)valueExpression).charValue());
            }
            if (type == Float.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                return (T)Float.valueOf(valueExpressionNumber.floatValue());
            }
            if (type == Double.TYPE) {
                Number valueExpressionNumber = (Number)valueExpression;
                return (T)Double.valueOf(valueExpressionNumber.doubleValue());
            }
            throw new IllegalStateException("Unmapped primitive " + type);
        }
        if (type == String.class) {
            return type.cast(String.valueOf(valueExpression));
        }
        if (type == BigInteger.class) {
            long longValue = valueExpression instanceof Long ? ((Long)valueExpression).longValue() : ((Number)valueExpression).longValue();
            return (T)BigInteger.valueOf(longValue);
        }
        return type.cast(valueExpression);
    }
}

