/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.internal;

import io.vavr.control.Either;
import java.time.Duration;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.internal.DefaultContextHandler;
import org.apache.plc4x.java.spi.internal.HandlerRegistration;

public class DefaultSendRequestContext<T>
implements ConversationContext.SendRequestContext<T> {
    protected String name;
    protected Deque<Either<Function<?, ?>, Predicate<?>>> commands = new LinkedList();
    protected final Consumer<HandlerRegistration> finisher;
    private final T request;
    private final ConversationContext<T> context;
    protected Class<?> expectClazz;
    protected Consumer<?> packetConsumer;
    protected Consumer<TimeoutException> onTimeoutConsumer;
    protected BiConsumer<?, ? extends Throwable> errorConsumer;
    protected Duration timeout = Duration.ofMillis(1000L);

    public DefaultSendRequestContext(String name, Consumer<HandlerRegistration> finisher, T request, ConversationContext<T> context) {
        this.name = name;
        this.finisher = finisher;
        this.request = request;
        this.context = context;
    }

    protected DefaultSendRequestContext(String name, Deque<Either<Function<?, ?>, Predicate<?>>> commands, Duration timeout, Consumer<HandlerRegistration> finisher, T request, ConversationContext<T> context, Class<?> expectClazz, Consumer<?> packetConsumer, Consumer<TimeoutException> onTimeoutConsumer, BiConsumer<?, ? extends Throwable> errorConsumer) {
        this.name = name;
        this.commands = commands;
        this.timeout = timeout;
        this.finisher = finisher;
        this.request = request;
        this.context = context;
        this.expectClazz = expectClazz;
        this.packetConsumer = packetConsumer;
        this.onTimeoutConsumer = onTimeoutConsumer;
        this.errorConsumer = errorConsumer;
    }

    @Override
    public ConversationContext.SendRequestContext<T> expectResponse(Class<T> clazz, Duration timeout) {
        this.timeout = timeout;
        if (this.expectClazz != null) {
            throw new ConversationContext.PlcWiringException("can't expect class of type " + clazz + " as we already expecting clazz of type " + this.expectClazz);
        }
        this.expectClazz = clazz;
        this.commands.addLast(Either.right(new TypePredicate(clazz)));
        return this;
    }

    @Override
    public ConversationContext.SendRequestContext<T> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ConversationContext.SendRequestContext<T> check(Predicate<T> checker) {
        this.commands.addLast(Either.right(checker));
        return this;
    }

    @Override
    public DefaultContextHandler handle(Consumer<T> packetConsumer) {
        if (this.packetConsumer != null) {
            throw new ConversationContext.PlcWiringException("can't handle multiple consumers");
        }
        this.packetConsumer = packetConsumer;
        HandlerRegistration registration = new HandlerRegistration(this.name, this.commands, this.expectClazz, packetConsumer, this.onTimeoutConsumer, this.errorConsumer, this.timeout);
        this.finisher.accept(registration);
        this.context.sendToWire(this.request);
        return new DefaultContextHandler(registration, registration::cancel);
    }

    @Override
    public ConversationContext.SendRequestContext<T> onTimeout(Consumer<TimeoutException> onTimeoutConsumer) {
        if (this.onTimeoutConsumer != null) {
            throw new ConversationContext.PlcWiringException("can't handle multiple timeout consumers");
        }
        this.onTimeoutConsumer = onTimeoutConsumer;
        return this;
    }

    @Override
    public <E extends Throwable> ConversationContext.SendRequestContext<T> onError(BiConsumer<T, E> errorConsumer) {
        if (this.errorConsumer != null) {
            throw new ConversationContext.PlcWiringException("can't handle multiple error consumers");
        }
        this.errorConsumer = errorConsumer;
        return this;
    }

    @Override
    public <R> ConversationContext.SendRequestContext<R> unwrap(Function<T, R> unwrapper) {
        if (this.expectClazz == null) {
            throw new ConversationContext.PlcWiringException("expectResponse must be called before first unwrap");
        }
        if (this.onTimeoutConsumer == null) {
            this.onTimeoutConsumer = new NoopTimeoutConsumer();
        }
        this.commands.addLast(Either.left(unwrapper));
        return new DefaultSendRequestContext<T>(this.name, this.commands, this.timeout, this.finisher, this.request, this.context, this.expectClazz, this.packetConsumer, this.onTimeoutConsumer, this.errorConsumer);
    }

    @Override
    public <R> ConversationContext.SendRequestContext<R> only(Class<R> clazz) {
        this.check(new TypePredicate(clazz));
        return this.unwrap(new CastFunction(clazz));
    }

    static class CastFunction<T, R>
    implements Function<R, T> {
        private final Class<T> type;

        CastFunction(Class<T> type) {
            this.type = type;
        }

        @Override
        public T apply(R value) {
            return this.type.cast(value);
        }
    }

    static class NoopTimeoutConsumer
    implements Consumer<TimeoutException> {
        NoopTimeoutConsumer() {
        }

        @Override
        public void accept(TimeoutException e) {
        }
    }

    static class TypePredicate<T, R>
    implements Predicate<R> {
        private final Class<T> type;

        TypePredicate(Class<T> type) {
            this.type = type;
        }

        @Override
        public boolean test(R value) {
            return this.type.isInstance(value);
        }
    }
}

