/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

public class PlcDWORD
extends PlcIECValue<Long> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static final Long minValue = 0L;
    static final Long maxValue = 0xFFFFFFFFL;

    public static PlcDWORD of(Object value) {
        if (value instanceof Boolean) {
            return new PlcDWORD((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcDWORD((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcDWORD((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcDWORD((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcDWORD((Long)value);
        }
        if (value instanceof Float) {
            return new PlcDWORD((Float)value);
        }
        if (value instanceof Double) {
            return new PlcDWORD((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcDWORD((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcDWORD((BigDecimal)value);
        }
        return new PlcDWORD((String)value);
    }

    public PlcDWORD(Boolean value) {
        this.value = value != false ? 1L : 0L;
        this.isNullable = false;
    }

    public PlcDWORD(Byte value) {
        if ((long)value.byteValue() < minValue || (long)value.byteValue() > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Short value) {
        if ((long)value.shortValue() < minValue || (long)value.shortValue() > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Integer value) {
        if ((long)value.intValue() < minValue || (long)value.intValue() > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Long value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = (long)value;
        this.isNullable = false;
    }

    public PlcDWORD(Float value) {
        if (value.floatValue() < (float)minValue.longValue() || value.floatValue() > (float)maxValue.longValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Double value) {
        if (value < (double)minValue.longValue() || value > (double)maxValue.longValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue)) < 0 || value.compareTo(BigInteger.valueOf(maxValue)) > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcDWORD(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0 || value.scale() > 0) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcDWORD(String value) {
        try {
            long val = Long.parseLong(value.trim());
            if (val < minValue || val > maxValue) {
                throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcDWORD(long value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidTagException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DWORD;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBoolean() {
        return this.value != null && !((Long)this.value).equals(0L);
    }

    public boolean[] getBooleanArray() {
        boolean[] booleanValues = new boolean[32];
        BitSet bitSet = BitSet.valueOf(new long[]{(Long)this.value});
        int i = 0;
        while (i < 32) {
            booleanValues[i] = bitSet.get(i);
            ++i;
        }
        return booleanValues;
    }

    @Override
    public boolean isByte() {
        return this.value != null && (Long)this.value <= 127L && (Long)this.value >= -128L;
    }

    @Override
    public byte getByte() {
        return ((Long)this.value).byteValue();
    }

    @Override
    public boolean isShort() {
        return this.value != null && (Long)this.value <= 32767L && (Long)this.value >= -32768L;
    }

    @Override
    public short getShort() {
        return ((Long)this.value).shortValue();
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public int getInteger() {
        return ((Long)this.value).intValue();
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        return (Long)this.value;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float getFloat() {
        return ((Long)this.value).floatValue();
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double getDouble() {
        return ((Long)this.value).doubleValue();
    }

    @Override
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return Long.toString((Long)this.value);
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Long)this.value >> 24 & 0xFFL), (byte)((Long)this.value >> 16 & 0xFFL), (byte)((Long)this.value >> 8 & 0xFFL), (byte)((Long)this.value & 0xFFL)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeLong(this.getClass().getSimpleName(), 32, (Long)this.value, new WithWriterArgs[0]);
    }
}

