/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import java.util.Locale;

public final class UnsignedShort
extends Number
implements Comparable<UnsignedShort> {
    public static final int BYTES = 2;
    public static final UnsignedShort ZERO = new UnsignedShort(0);
    public static final UnsignedShort ONE = new UnsignedShort(1);
    public static final UnsignedShort MIN_VALUE = ZERO;
    public static final UnsignedShort MAX_VALUE = new UnsignedShort(-1);
    private final short value;

    public static String toString(short s) {
        return Integer.toString(s >= 0 ? s : 0xFFFF & s);
    }

    public static UnsignedShort valueOf(short s) {
        if (s == -1) {
            return MAX_VALUE;
        }
        if (s == 0) {
            return ZERO;
        }
        if (s == 1) {
            return ONE;
        }
        return new UnsignedShort(s);
    }

    public static UnsignedShort valueOf(String s) {
        return UnsignedShort.valueOf(s, 10);
    }

    public static UnsignedShort valueOf(String s, int radix) {
        int i = Integer.parseInt(s, radix);
        if (i < 0 || i > 65535) {
            throw new NumberFormatException(String.format(Locale.ROOT, "String value %s exceeds range of unsigned short.", s));
        }
        return UnsignedShort.valueOf((short)Integer.parseInt(s, radix));
    }

    private UnsignedShort(short value) {
        this.value = value;
    }

    public UnsignedShort add(UnsignedShort val) {
        if (val == null || val.value == 0) {
            return this;
        }
        return UnsignedShort.valueOf((short)(this.value + val.value));
    }

    public UnsignedShort subtract(UnsignedShort val) {
        if (val == null || val.value == 0) {
            return this;
        }
        return UnsignedShort.valueOf((short)(this.value - val.value));
    }

    public UnsignedShort multiply(UnsignedShort val) {
        if ((long)this.value == 0L || val == null || (long)val.value == 0L) {
            return ZERO;
        }
        return UnsignedShort.valueOf((short)(this.value * val.value));
    }

    public UnsignedShort divide(UnsignedShort val) {
        return UnsignedShort.valueOf((short)Integer.divideUnsigned(this.intValue(), val == null ? 0 : val.intValue()));
    }

    public UnsignedShort remainder(UnsignedShort val) {
        return UnsignedShort.valueOf((short)Integer.remainderUnsigned(this.intValue(), val == null ? 0 : val.intValue()));
    }

    @Override
    public int intValue() {
        return this.value >= 0 ? this.value : 0xFFFF & this.value;
    }

    @Override
    public long longValue() {
        return this.value >= 0 ? (long)this.value : 0xFFFFL & (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public int compareTo(UnsignedShort o) {
        return Integer.compareUnsigned(this.intValue(), o == null ? 0 : o.intValue());
    }

    public int hashCode() {
        return 0xFFFF & this.value + 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value == ((UnsignedShort)obj).value;
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public String toString(int radix) {
        return Integer.toString(this.intValue(), radix);
    }
}

