/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.utils;

import com.alibaba.nacos.api.common.Constants;

public class ContentUtils {
    private static final int SHOW_CONTENT_SIZE = 100;

    public static void verifyIncrementPubContent(String content) {
        if (content == null || content.length() == 0) {
            throw new IllegalArgumentException("publish/delete content can not be null");
        }
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\r' || c == '\n') {
                throw new IllegalArgumentException("publish/delete content can not contain return and linefeed");
            }
            if (c != Constants.WORD_SEPARATOR.charAt(0)) continue;
            throw new IllegalArgumentException("publish/delete content can not contain(char)2");
        }
    }

    public static String getContentIdentity(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("content does not contain separator");
        }
        return content.substring(0, index);
    }

    public static String getContent(String content) {
        int index = content.indexOf(Constants.WORD_SEPARATOR);
        if (index == -1) {
            throw new IllegalArgumentException("content does not contain separator");
        }
        return content.substring(index + 1);
    }

    public static String truncateContent(String content) {
        if (content == null) {
            return "";
        }
        if (content.length() <= 100) {
            return content;
        }
        return content.substring(0, 100) + "...";
    }
}

