/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.log4j2;

import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.common.utils.ResourceUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4J2NacosLogging
extends AbstractNacosLogging {
    private static final String NACOS_LOG4J2_LOCATION = "classpath:nacos-log4j2.xml";
    private static final String FILE_PROTOCOL = "file";
    private static final String NACOS_LOGGER_PREFIX = "com.alibaba.nacos";
    private static final String NACOS_LOG4J2_PLUGIN_PACKAGE = "com.alibaba.nacos.client.logging.log4j2";
    private final String location = this.getLocation("classpath:nacos-log4j2.xml");

    @Override
    public void loadConfiguration() {
        if (StringUtils.isBlank(this.location)) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration contextConfiguration = loggerContext.getConfiguration();
        Configuration configuration = this.loadConfiguration(loggerContext, this.location);
        configuration.getPluginPackages().add(NACOS_LOG4J2_PLUGIN_PACKAGE);
        configuration.start();
        Map appenders = configuration.getAppenders();
        for (Appender appender : appenders.values()) {
            contextConfiguration.addAppender(appender);
        }
        Map loggers = configuration.getLoggers();
        for (String name : loggers.keySet()) {
            if (!name.startsWith(NACOS_LOGGER_PREFIX)) continue;
            contextConfiguration.addLogger(name, (LoggerConfig)loggers.get(name));
        }
        loggerContext.updateLoggers();
    }

    private Configuration loadConfiguration(LoggerContext loggerContext, String location) {
        try {
            URL url = ResourceUtils.getResourceUrl(location);
            ConfigurationSource source = this.getConfigurationSource(url);
            return ConfigurationFactory.getInstance().getConfiguration(loggerContext, source);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Log4J2 logging from " + location, e);
        }
    }

    private ConfigurationSource getConfigurationSource(URL url) throws IOException {
        InputStream stream = url.openStream();
        if (FILE_PROTOCOL.equals(url.getProtocol())) {
            return new ConfigurationSource(stream, ResourceUtils.getResourceAsFile(url));
        }
        return new ConfigurationSource(stream, url);
    }
}

