/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.AbstractNacosRestTemplate;
import com.alibaba.nacos.common.http.client.HttpClientRequestInterceptor;
import com.alibaba.nacos.common.http.client.InterceptingHttpClientRequest;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.request.HttpClientRequest;
import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import com.alibaba.nacos.common.utils.CollectionUtils;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class NacosRestTemplate
extends AbstractNacosRestTemplate {
    private final HttpClientRequest requestClient;
    private final List<HttpClientRequestInterceptor> interceptors = new ArrayList<HttpClientRequestInterceptor>();

    public NacosRestTemplate(Logger logger, HttpClientRequest requestClient) {
        super(logger);
        this.requestClient = requestClient;
    }

    public <T> HttpRestResult<T> get(String url, Header header, Query query, Type responseType) throws Exception {
        return this.execute(url, "GET", new RequestHttpEntity(header, query), responseType);
    }

    public <T> HttpRestResult<T> get(String url, HttpClientConfig config, Header header, Query query, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(config, header, query);
        return this.execute(url, "GET", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> getLarge(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "GET-LARGE", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> delete(String url, Header header, Query query, Type responseType) throws Exception {
        return this.execute(url, "DELETE", new RequestHttpEntity(header, query), responseType);
    }

    public <T> HttpRestResult<T> delete(String url, HttpClientConfig config, Header header, Query query, Type responseType) throws Exception {
        return this.execute(url, "DELETE", new RequestHttpEntity(config, header, query), responseType);
    }

    public <T> HttpRestResult<T> put(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "PUT", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> putJson(String url, Header header, Query query, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json;charset=UTF-8"), query, (Object)body);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putJson(String url, Header header, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json;charset=UTF-8"), body);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), query, bodyValues);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putForm(String url, Header header, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), bodyValues);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putForm(String url, HttpClientConfig config, Header header, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(config, header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), bodyValues);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> post(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "POST", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> postJson(String url, Header header, Query query, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json;charset=UTF-8"), query, (Object)body);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postJson(String url, Header header, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json;charset=UTF-8"), body);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), query, bodyValues);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postForm(String url, Header header, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), bodyValues);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postForm(String url, HttpClientConfig config, Header header, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(config, header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), bodyValues);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> exchangeForm(String url, Header header, Query query, Map<String, String> bodyValues, String httpMethod, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded;charset=UTF-8"), query, bodyValues);
        return this.execute(url, httpMethod, requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> exchange(String url, HttpClientConfig config, Header header, Query query, Object body, String httpMethod, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(config, header, query, body);
        return this.execute(url, httpMethod, requestHttpEntity, responseType);
    }

    public void setInterceptors(List<HttpClientRequestInterceptor> interceptors) {
        if (this.interceptors != interceptors) {
            this.interceptors.clear();
            this.interceptors.addAll(interceptors);
        }
    }

    public List<HttpClientRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpRestResult<T> execute(String url, String httpMethod, RequestHttpEntity requestEntity, Type responseType) throws Exception {
        URI uri = HttpUtils.buildUri(url, requestEntity.getQuery());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("HTTP method: {}, url: {}, body: {}", new Object[]{httpMethod, uri, requestEntity.getBody()});
        }
        ResponseHandler responseHandler = super.selectResponseHandler(responseType);
        try (HttpClientResponse response = null;){
            response = this.requestClient().execute(uri, httpMethod, requestEntity);
            HttpRestResult httpRestResult = responseHandler.handle(response);
            return httpRestResult;
        }
    }

    private HttpClientRequest requestClient() {
        if (CollectionUtils.isNotEmpty(this.interceptors)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Execute via interceptors :{}", this.interceptors);
            }
            return new InterceptingHttpClientRequest(this.requestClient, this.interceptors.iterator());
        }
        return this.requestClient;
    }

    public void close() throws Exception {
        this.requestClient.close();
    }
}

