/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

public interface BoundaryNodeRule {
    public static final BoundaryNodeRule MOD2_BOUNDARY_RULE = new Mod2BoundaryNodeRule();
    public static final BoundaryNodeRule ENDPOINT_BOUNDARY_RULE = new EndPointBoundaryNodeRule();
    public static final BoundaryNodeRule MULTIVALENT_ENDPOINT_BOUNDARY_RULE = new MultiValentEndPointBoundaryNodeRule();
    public static final BoundaryNodeRule MONOVALENT_ENDPOINT_BOUNDARY_RULE = new MonoValentEndPointBoundaryNodeRule();
    public static final BoundaryNodeRule OGC_SFS_BOUNDARY_RULE = MOD2_BOUNDARY_RULE;

    public boolean isInBoundary(int var1);

    public static class MonoValentEndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int boundaryCount) {
            return boundaryCount == 1;
        }
    }

    public static class MultiValentEndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int boundaryCount) {
            return boundaryCount > 1;
        }
    }

    public static class EndPointBoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int boundaryCount) {
            return boundaryCount > 0;
        }
    }

    public static class Mod2BoundaryNodeRule
    implements BoundaryNodeRule {
        @Override
        public boolean isInBoundary(int boundaryCount) {
            return boundaryCount % 2 == 1;
        }
    }
}

