/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;

public class SerializedJwt {
    private final String token;
    private final String header;
    private final String payload;
    private final String signature;

    public SerializedJwt(String token) {
        token = token == null ? "" : token.trim();
        if (token.isEmpty()) {
            throw new ValidateException("Empty JWT provided; expected three sections (header, payload, and signature)");
        }
        String[] splits = token.split("\\.");
        if (splits.length != 3) {
            throw new ValidateException(String.format("Malformed JWT provided (%s); expected three sections (header, payload, and signature), but %d sections provided", token, splits.length));
        }
        this.token = token.trim();
        this.header = this.validateSection(splits[0], "header");
        this.payload = this.validateSection(splits[1], "payload");
        this.signature = this.validateSection(splits[2], "signature");
    }

    public String getToken() {
        return this.token;
    }

    public String getHeader() {
        return this.header;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    private String validateSection(String section, String sectionName) throws ValidateException {
        if ((section = section.trim()).isEmpty()) {
            throw new ValidateException(String.format("Malformed JWT provided; expected at least three sections (header, payload, and signature), but %s section missing", sectionName));
        }
        return section;
    }
}

