/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class StringDeserializer
implements Deserializer<String> {
    private String encoding = StandardCharsets.UTF_8.name();

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.deserializer.encoding" : "value.deserializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    @Override
    public String deserialize(String topic, byte[] data) {
        try {
            if (data == null) {
                return null;
            }
            return new String(data, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to string due to unsupported encoding " + this.encoding);
        }
    }

    @Override
    public String deserialize(String topic, Headers headers, ByteBuffer data) {
        if (data == null) {
            return null;
        }
        try {
            if (data.hasArray()) {
                return new String(data.array(), data.position() + data.arrayOffset(), data.remaining(), this.encoding);
            }
            return new String(Utils.toArray(data), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing ByteBuffer to string due to unsupported encoding " + this.encoding);
        }
    }
}

