/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ModbusPDUReadWriteMultipleHoldingRegistersRequest
extends ModbusPDU
implements Message {
    protected final int readStartingAddress;
    protected final int readQuantity;
    protected final int writeStartingAddress;
    protected final int writeQuantity;
    protected final byte[] value;

    @Override
    public Boolean getErrorFlag() {
        return false;
    }

    @Override
    public Byte getFunctionFlag() {
        return (byte)23;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public ModbusPDUReadWriteMultipleHoldingRegistersRequest(int readStartingAddress, int readQuantity, int writeStartingAddress, int writeQuantity, byte[] value) {
        this.readStartingAddress = readStartingAddress;
        this.readQuantity = readQuantity;
        this.writeStartingAddress = writeStartingAddress;
        this.writeQuantity = writeQuantity;
        this.value = value;
    }

    public int getReadStartingAddress() {
        return this.readStartingAddress;
    }

    public int getReadQuantity() {
        return this.readQuantity;
    }

    public int getWriteStartingAddress() {
        return this.writeStartingAddress;
    }

    public int getWriteQuantity() {
        return this.writeQuantity;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusPDUReadWriteMultipleHoldingRegistersRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"readStartingAddress", (Object)this.readStartingAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"readQuantity", (Object)this.readQuantity, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writeStartingAddress", (Object)this.writeStartingAddress, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writeQuantity", (Object)this.writeQuantity, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        short byteCount = (short)StaticHelper.COUNT((Object)this.getValue());
        FieldWriterFactory.writeImplicitField((String)"byteCount", (Object)byteCount, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"value", (byte[])this.value, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUReadWriteMultipleHoldingRegistersRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusPDUReadWriteMultipleHoldingRegistersRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 8;
        if (this.value != null) {
            lengthInBits += 8 * this.value.length;
        }
        return lengthInBits;
    }

    public static ModbusPDU.ModbusPDUBuilder staticParseModbusPDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusPDUReadWriteMultipleHoldingRegistersRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int readStartingAddress = (Integer)FieldReaderFactory.readSimpleField((String)"readStartingAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int readQuantity = (Integer)FieldReaderFactory.readSimpleField((String)"readQuantity", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int writeStartingAddress = (Integer)FieldReaderFactory.readSimpleField((String)"writeStartingAddress", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int writeQuantity = (Integer)FieldReaderFactory.readSimpleField((String)"writeQuantity", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        short byteCount = (Short)FieldReaderFactory.readImplicitField((String)"byteCount", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] value = readBuffer.readByteArray("value", Math.toIntExact(byteCount), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUReadWriteMultipleHoldingRegistersRequest", new WithReaderArgs[0]);
        return new ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilderImpl(readStartingAddress, readQuantity, writeStartingAddress, writeQuantity, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadWriteMultipleHoldingRegistersRequest)) {
            return false;
        }
        ModbusPDUReadWriteMultipleHoldingRegistersRequest that = (ModbusPDUReadWriteMultipleHoldingRegistersRequest)o;
        return this.getReadStartingAddress() == that.getReadStartingAddress() && this.getReadQuantity() == that.getReadQuantity() && this.getWriteStartingAddress() == that.getWriteStartingAddress() && this.getWriteQuantity() == that.getWriteQuantity() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getReadStartingAddress(), this.getReadQuantity(), this.getWriteStartingAddress(), this.getWriteQuantity(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilderImpl
    implements ModbusPDU.ModbusPDUBuilder {
        private final int readStartingAddress;
        private final int readQuantity;
        private final int writeStartingAddress;
        private final int writeQuantity;
        private final byte[] value;

        public ModbusPDUReadWriteMultipleHoldingRegistersRequestBuilderImpl(int readStartingAddress, int readQuantity, int writeStartingAddress, int writeQuantity, byte[] value) {
            this.readStartingAddress = readStartingAddress;
            this.readQuantity = readQuantity;
            this.writeStartingAddress = writeStartingAddress;
            this.writeQuantity = writeQuantity;
            this.value = value;
        }

        @Override
        public ModbusPDUReadWriteMultipleHoldingRegistersRequest build() {
            ModbusPDUReadWriteMultipleHoldingRegistersRequest modbusPDUReadWriteMultipleHoldingRegistersRequest = new ModbusPDUReadWriteMultipleHoldingRegistersRequest(this.readStartingAddress, this.readQuantity, this.writeStartingAddress, this.writeQuantity, this.value);
            return modbusPDUReadWriteMultipleHoldingRegistersRequest;
        }
    }
}

