/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHeaderGroup {
    TestHeaderGroup() {
    }

    @Test
    void testConstructor() {
        HeaderGroup headergroup = new HeaderGroup();
        Assertions.assertNotNull((Object)headergroup.getHeaders());
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders().length);
    }

    @Test
    void testClear() {
        HeaderGroup headergroup = new HeaderGroup();
        headergroup.addHeader((Header)new BasicHeader("name", (Object)"value"));
        Assertions.assertEquals((int)1, (int)headergroup.getHeaders().length);
        headergroup.clear();
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders().length);
    }

    @Test
    void testAddRemoveHeader() {
        HeaderGroup headerGroup = new HeaderGroup();
        BasicHeader header = new BasicHeader("name", (Object)"value");
        headerGroup.addHeader((Header)header);
        headerGroup.addHeader(null);
        Assertions.assertEquals((int)1, (int)headerGroup.getHeaders().length);
        Assertions.assertTrue((boolean)headerGroup.removeHeader((Header)header));
        Assertions.assertFalse((boolean)headerGroup.removeHeader(null));
        Assertions.assertEquals((int)0, (int)headerGroup.getHeaders().length);
    }

    @Test
    void testAddRemoveHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header = new BasicHeader("name", (Object)"value");
        headergroup.addHeader((Header)header);
        headergroup.addHeader((Header)header);
        Assertions.assertEquals((int)2, (int)headergroup.getHeaders().length);
        Assertions.assertFalse((boolean)headergroup.removeHeaders((Header)null));
        Assertions.assertTrue((boolean)headergroup.removeHeaders((Header)header));
        Assertions.assertFalse((boolean)headergroup.removeHeaders((Header)null));
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders().length);
    }

    @Test
    void testAddRemoveHeaderWithDifferentButEqualHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header = new BasicHeader("name", (Object)"value");
        BasicHeader header2 = new BasicHeader("name", (Object)"value");
        headergroup.addHeader((Header)header);
        Assertions.assertEquals((int)1, (int)headergroup.getHeaders().length);
        Assertions.assertTrue((boolean)headergroup.removeHeader((Header)header2));
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders().length);
    }

    @Test
    void testUpdateHeader() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name1", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name2", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name3", (Object)"value3");
        headergroup.addHeader((Header)header1);
        headergroup.addHeader((Header)header2);
        headergroup.addHeader((Header)header3);
        headergroup.setHeader((Header)new BasicHeader("name2", (Object)"newvalue"));
        headergroup.setHeader((Header)new BasicHeader("name4", (Object)"value4"));
        headergroup.setHeader(null);
        Assertions.assertEquals((int)4, (int)headergroup.getHeaders().length);
        Assertions.assertEquals((Object)"newvalue", (Object)headergroup.getFirstHeader("name2").getValue());
    }

    @Test
    void testSetHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name1", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name2", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name3", (Object)"value3");
        headergroup.addHeader((Header)header1);
        headergroup.setHeaders(new Header[]{header2, header3});
        Assertions.assertEquals((int)2, (int)headergroup.getHeaders().length);
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders("name1").length);
        Assertions.assertFalse((boolean)headergroup.containsHeader("name1"));
        Assertions.assertEquals((int)1, (int)headergroup.getHeaders("name2").length);
        Assertions.assertTrue((boolean)headergroup.containsHeader("name2"));
        Assertions.assertEquals((int)1, (int)headergroup.getHeaders("name3").length);
        Assertions.assertTrue((boolean)headergroup.containsHeader("name3"));
        headergroup.setHeaders(new Header[0]);
        Assertions.assertEquals((int)0, (int)headergroup.getHeaders().length);
    }

    @Test
    void testFirstLastHeaders() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name", (Object)"value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        Assertions.assertNull((Object)headergroup.getFirstHeader("whatever"));
        Assertions.assertNull((Object)headergroup.getLastHeader("whatever"));
        Assertions.assertEquals((Object)"value1", (Object)headergroup.getFirstHeader("name").getValue());
        Assertions.assertEquals((Object)"value3", (Object)headergroup.getLastHeader("name").getValue());
    }

    @Test
    void testCondensedHeader() {
        HeaderGroup headergroup = new HeaderGroup();
        Assertions.assertNull((Object)headergroup.getCondensedHeader("name"));
        BasicHeader header1 = new BasicHeader("name", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name", (Object)"value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        Assertions.assertEquals((Object)"value1, value2, value3", (Object)headergroup.getCondensedHeader("name").getValue());
        headergroup.setHeaders(new Header[]{header1});
        Assertions.assertEquals((Object)header1, (Object)headergroup.getCondensedHeader("name"));
    }

    @Test
    void testIterator() {
        HeaderGroup headergroup = new HeaderGroup();
        Iterator i = headergroup.headerIterator();
        Assertions.assertNotNull((Object)i);
        Assertions.assertFalse((boolean)i.hasNext());
    }

    @Test
    void testHeaderRemove() {
        HeaderGroup headergroup = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name", (Object)"value3");
        headergroup.setHeaders(new Header[]{header1, header2, header3});
        Iterator i = headergroup.headerIterator();
        Assertions.assertNotNull((Object)i);
        Assertions.assertTrue((boolean)i.hasNext());
        i.next();
        Assertions.assertTrue((boolean)i.hasNext());
        i.next();
        i.remove();
        Assertions.assertEquals((int)2, (int)headergroup.getHeaders().length);
        Assertions.assertTrue((boolean)i.hasNext());
        i.next();
        i.remove();
        Assertions.assertEquals((int)1, (int)headergroup.getHeaders().length);
        Assertions.assertFalse((boolean)i.hasNext());
    }

    @Test
    void testSerialization() throws Exception {
        HeaderGroup orig = new HeaderGroup();
        BasicHeader header1 = new BasicHeader("name", (Object)"value1");
        BasicHeader header2 = new BasicHeader("name", (Object)"value2");
        BasicHeader header3 = new BasicHeader("name", (Object)"value3");
        orig.setHeaders(new Header[]{header1, header2, header3});
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        HeaderGroup clone = (HeaderGroup)inStream.readObject();
        Header[] headers1 = orig.getHeaders();
        Header[] headers2 = clone.getHeaders();
        Assertions.assertNotNull((Object)headers1);
        Assertions.assertNotNull((Object)headers2);
        Assertions.assertEquals((int)headers1.length, (int)headers2.length);
        for (int i = 0; i < headers1.length; ++i) {
            Assertions.assertEquals((Object)headers1[i].getName(), (Object)headers2[i].getName());
            Assertions.assertEquals((Object)headers1[i].getValue(), (Object)headers2[i].getValue());
        }
    }
}

