/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcQueryFetchResult
extends Response {
    private List<ByteBuffer> rowTuples;
    private boolean last;

    public JdbcQueryFetchResult() {
    }

    public JdbcQueryFetchResult(int status, String err) {
        super(status, err);
    }

    public JdbcQueryFetchResult(List<ByteBuffer> rowTuples, boolean last) {
        Objects.requireNonNull(rowTuples);
        this.rowTuples = rowTuples;
        this.last = last;
    }

    public List<ByteBuffer> items() {
        return this.rowTuples;
    }

    public boolean last() {
        return this.last;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packBoolean(this.last);
        packer.packInt(this.rowTuples.size());
        for (ByteBuffer item : this.rowTuples) {
            packer.packByteBuffer(item);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        this.last = unpacker.unpackBoolean();
        int size = unpacker.unpackInt();
        this.rowTuples = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            this.rowTuples.add(ByteBuffer.wrap(unpacker.readBinary()).order(BinaryTupleParser.ORDER));
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryFetchResult.class, (Object)this);
    }
}

