/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.client.proto;

import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final ProtocolVersion V3_0_0;
    public static final ProtocolVersion LATEST_VER;
    private final short major;
    private final short minor;
    private final short patch;

    public ProtocolVersion(short major, short minor, short patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static ProtocolVersion unpack(ClientMessageUnpacker unpacker) {
        return new ProtocolVersion(unpacker.unpackShort(), unpacker.unpackShort(), unpacker.unpackShort());
    }

    public void pack(ClientMessagePacker packer) {
        packer.packShort(this.major);
        packer.packShort(this.minor);
        packer.packShort(this.patch);
    }

    public short major() {
        return this.major;
    }

    public short minor() {
        return this.minor;
    }

    public short patch() {
        return this.patch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProtocolVersion)) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int res = 31 * this.major;
        return res += (this.minor & 0xFFFF) << 16 & (this.patch & 0xFFFF);
    }

    @Override
    public int compareTo(ProtocolVersion other) {
        int diff = this.major - other.major;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        return this.patch - other.patch;
    }

    public String toString() {
        return S.toString(ProtocolVersion.class, this);
    }

    static {
        LATEST_VER = V3_0_0 = new ProtocolVersion(3, 0, 0);
    }
}

