/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.thread;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.shaded.org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.shaded.org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;
import org.apache.ignite.shaded.org.apache.ignite.internal.thread.ThreadOperation;

public class IgniteThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler exHnd;
    private final ThreadOperation[] allowedOperations;

    protected IgniteThreadFactory(String nodeName, String poolName, boolean daemon, IgniteLogger log, ThreadOperation[] allowedOperations) {
        this(IgniteThread.threadPrefix(nodeName, poolName), daemon, log, allowedOperations);
    }

    protected IgniteThreadFactory(String prefix, boolean daemon, IgniteLogger log, ThreadOperation[] allowedOperations) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.daemon = daemon;
        this.exHnd = new LogUncaughtExceptionHandler(log);
        this.allowedOperations = allowedOperations;
    }

    @Override
    public IgniteThread newThread(Runnable r) {
        IgniteThread t = this.createIgniteThread(this.prefix + this.counter.getAndIncrement(), r, this.allowedOperations);
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler(this.exHnd);
        return t;
    }

    protected IgniteThread createIgniteThread(String finalName, Runnable r, ThreadOperation ... allowedOperations) {
        return new IgniteThread(finalName, r, allowedOperations);
    }

    public String prefix() {
        return this.prefix;
    }

    public static IgniteThreadFactory create(String nodeName, String poolName, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return IgniteThreadFactory.create(nodeName, poolName, false, logger, allowedOperations);
    }

    public static IgniteThreadFactory create(String nodeName, String poolName, boolean daemon, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return new IgniteThreadFactory(nodeName, poolName, daemon, logger, allowedOperations);
    }

    public static IgniteThreadFactory createWithFixedPrefix(String prefix, boolean daemon, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return new IgniteThreadFactory(prefix, daemon, logger, allowedOperations);
    }
}

