/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.table.mapper;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.MapperBuilder;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.OneColumnMapperImpl;
import org.apache.ignite.shaded.org.apache.ignite.table.mapper.TypeConverter;

public interface Mapper<T> {
    public static <O> Mapper<O> of(Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return new OneColumnMapperImpl<O>(type, null, null);
        }
        return Mapper.builder(type).automap().build();
    }

    public static <O> Mapper<O> of(Class<O> type, String columnName) {
        return new OneColumnMapperImpl<O>(Mapper.ensureNativelySupported(type), columnName, null);
    }

    public static <ObjectT, ColumnT> Mapper<ObjectT> of(Class<ObjectT> type, String columnName, TypeConverter<ObjectT, ColumnT> converter) {
        return new OneColumnMapperImpl<ObjectT>(Objects.requireNonNull(type), Objects.requireNonNull(columnName), Objects.requireNonNull(converter));
    }

    public static <O> Mapper<O> of(Class<O> type, String fieldName, String columnName, String ... fieldColumnPairs) {
        if (fieldColumnPairs.length % 2 != 0) {
            throw new IllegalArgumentException("Missed a column name, which the field is mapped to: " + fieldColumnPairs[fieldColumnPairs.length - 1]);
        }
        return Mapper.builder(type).map(Objects.requireNonNull(fieldName), Objects.requireNonNull(columnName), fieldColumnPairs).build();
    }

    public static <O> MapperBuilder<O> builder(Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return new MapperBuilder<O>(type, null);
        }
        return new MapperBuilder<O>(type);
    }

    public static <O> Class<O> ensureNativelySupported(Class<O> type) {
        if (Mapper.nativelySupported(type)) {
            return type;
        }
        throw new IllegalArgumentException("Class has no native support (type converter required): " + type.getName());
    }

    public static boolean nativelySupported(Class<?> type) {
        if (Objects.requireNonNull(type).isPrimitive()) {
            return false;
        }
        return String.class == type || Boolean.class == type || UUID.class == type || byte[].class == type || LocalDate.class == type || LocalTime.class == type || LocalDateTime.class == type || Instant.class == type || Void.class == type || BigDecimal.class == type || Byte.class == type || Short.class == type || Integer.class == type || Long.class == type || Float.class == type || Double.class == type;
    }

    public Class<T> targetType();
}

