/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumCache;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class BinaryEnumObjectImpl
implements BinaryObjectEx,
Externalizable,
CacheObject {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private BinaryContext ctx;
    private int typeId;
    private String clsName;
    private int ord;
    @GridDirectTransient
    private byte[] valBytes;

    public BinaryEnumObjectImpl() {
    }

    public BinaryEnumObjectImpl(BinaryContext ctx, int typeId, @Nullable String clsName, int ord) {
        assert (ctx != null);
        this.ctx = ctx;
        this.typeId = typeId;
        this.clsName = clsName;
        this.ord = ord;
    }

    public BinaryEnumObjectImpl(BinaryContext ctx, byte[] arr) {
        assert (ctx != null);
        assert (arr != null);
        if (arr[0] == 28) {
            this.valBytes = arr;
        } else {
            assert (arr[0] == 38);
            this.valBytes = new byte[arr.length];
            this.valBytes[0] = 28;
            U.arrayCopy(arr, 1, this.valBytes, 1, arr.length - 1);
        }
        this.ctx = ctx;
        int off = 1;
        this.typeId = BinaryPrimitives.readInt(arr, off);
        off += 4;
        if (this.typeId == 0) {
            assert (arr[off] == 9);
            int len = BinaryPrimitives.readInt(arr, ++off);
            byte[] bytes = BinaryPrimitives.readByteArray(arr, off += 4, len);
            off += len;
            this.clsName = new String(bytes, StandardCharsets.UTF_8);
        }
        this.ord = BinaryPrimitives.readInt(arr, off);
    }

    @Nullable
    public String className() {
        return this.clsName;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public BinaryType type() throws BinaryObjectException {
        return BinaryUtils.typeProxy(this.ctx, this);
    }

    @Override
    @Nullable
    public BinaryType rawType() throws BinaryObjectException {
        return BinaryUtils.type(this.ctx, this);
    }

    @Override
    public boolean isFlagSet(short flag) {
        return false;
    }

    @Override
    public <F> F field(String fieldName) throws BinaryObjectException {
        return null;
    }

    @Override
    public boolean hasField(String fieldName) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(@Nullable ClassLoader ldr) throws BinaryObjectException {
        ClassLoader resolveLdr;
        ClassLoader classLoader = resolveLdr = ldr == null ? this.ctx.configuration().getClassLoader() : ldr;
        if (ldr != null) {
            GridBinaryMarshaller.USE_CACHE.set(Boolean.FALSE);
        }
        try {
            Class cls = BinaryUtils.resolveClass(this.ctx, this.typeId, this.clsName, resolveLdr, false);
            T t = ldr == null ? BinaryEnumCache.get(cls, this.ord) : this.uncachedValue(cls);
            return t;
        }
        finally {
            GridBinaryMarshaller.USE_CACHE.set(Boolean.TRUE);
        }
    }

    private <T> T uncachedValue(Class<?> cls) throws BinaryObjectException {
        assert (cls != null);
        assert (!GridBinaryMarshaller.USE_CACHE.get().booleanValue());
        if (this.ord >= 0) {
            ?[] vals = cls.getEnumConstants();
            if (this.ord < vals.length) {
                return (T)vals[this.ord];
            }
            throw new BinaryObjectException("Failed to get enum value for ordinal (do you have correct class version?) [cls=" + cls.getName() + ", ordinal=" + this.ord + ", totalValues=" + vals.length + "]");
        }
        return null;
    }

    @Override
    public <T> T deserialize() throws BinaryObjectException {
        return this.deserialize(null);
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return (BinaryObject)super.clone();
    }

    @Override
    public BinaryObjectBuilder toBuilder() throws BinaryObjectException {
        throw new UnsupportedOperationException("Builder cannot be created for enum.");
    }

    @Override
    public int enumOrdinal() throws BinaryObjectException {
        return this.ord;
    }

    @Override
    public String enumName() throws BinaryObjectException {
        BinaryMetadata metadata = this.ctx.metadata0(this.typeId);
        if (metadata == null) {
            throw new BinaryObjectException("Failed to get metadata for enum [typeId=" + this.typeId + ", typeName='" + this.clsName + "', ordinal=" + this.ord + "]");
        }
        String name = metadata.getEnumNameByOrdinal(this.ord);
        if (name == null) {
            throw new BinaryObjectException("Unable to resolve enum constant name [typeId=" + this.typeId + ", typeName='" + metadata.typeName() + "', ordinal=" + this.ord + "]");
        }
        return name;
    }

    public int hashCode() {
        return 31 * this.typeId + this.ord;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BinaryEnumObjectImpl) {
            BinaryEnumObjectImpl other = (BinaryEnumObjectImpl)obj;
            return this.typeId == other.typeId && this.ord == other.ord;
        }
        return false;
    }

    public String toString() {
        if (!S.includeSensitive()) {
            return this.ord >= 0 ? "BinaryEnum" : "null";
        }
        try {
            Object val = this.deserialize();
            return new SB().a(val).toString();
        }
        catch (Exception val) {
            BinaryType type;
            try {
                type = this.rawType();
            }
            catch (Exception ignored) {
                type = null;
            }
            if (type != null) {
                return S.toString(type.typeName(), "ordinal", (Object)this.ord, true);
            }
            if (this.typeId == 0) {
                return S.toString("BinaryEnum", "clsName", (Object)this.clsName, true, "ordinal", (Object)this.ord, true);
            }
            return S.toString("BinaryEnum", "typeId", (Object)this.typeId, true, "ordinal", (Object)this.ord, true);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.typeId);
        out.writeObject(this.clsName);
        out.writeInt(this.ord);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = GridBinaryMarshaller.threadLocalContext();
        this.typeId = in.readInt();
        this.clsName = (String)in.readObject();
        this.ord = in.readInt();
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return this.value(ctx, cpy, null);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        return this.deserialize(ldr);
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext cacheCtx) throws IgniteCheckedException {
        if (this.valBytes != null) {
            return this.valBytes;
        }
        this.valBytes = U.marshal(this.ctx.marshaller(), (Object)this);
        return this.valBytes;
    }

    @Override
    public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
        assert (this.valBytes != null) : "Value bytes must be initialized before object is stored";
        return this.putValue(buf, 0, CacheObjectAdapter.objectPutSize(this.valBytes.length));
    }

    @Override
    public int putValue(long addr) throws IgniteCheckedException {
        assert (this.valBytes != null) : "Value bytes must be initialized before object is stored";
        return CacheObjectAdapter.putValue(addr, this.cacheObjectType(), this.valBytes);
    }

    @Override
    public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
        return CacheObjectAdapter.putValue(this.cacheObjectType(), buf, off, len, this.valBytes, 0);
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        return CacheObjectAdapter.objectPutSize(this.valueBytes(ctx).length);
    }

    @Override
    public byte cacheObjectType() {
        return 101;
    }

    @Override
    public boolean isPlatformType() {
        return false;
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        return this;
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.ctx = ((CacheObjectBinaryProcessorImpl)ctx.kernalContext().cacheObjects()).binaryContext();
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public short directType() {
        return 119;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("clsName", this.clsName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("ord", this.ord)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("typeId", this.typeId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.clsName = reader.readString("clsName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.ord = reader.readInt("ord");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.typeId = reader.readInt("typeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryEnumObjectImpl.class);
    }

    @Override
    public int size() {
        if (this.valBytes == null) {
            try {
                this.valBytes = U.marshal(this.ctx.marshaller(), (Object)this);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
        return BinaryPrimitives.readInt(this.valBytes, this.ord + 12);
    }
}

