/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore.accumulator;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite3.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.util.subscription.AccumulateException;
import org.apache.ignite3.internal.util.subscription.Accumulator;

public class NodeStatusAccumulator
implements Accumulator<Entry, List<UnitNodeStatus>> {
    private final List<UnitNodeStatus> nodes = new ArrayList<UnitNodeStatus>();
    private final Predicate<UnitNodeStatus> filter;

    public NodeStatusAccumulator() {
        this(status -> true);
    }

    public NodeStatusAccumulator(Predicate<UnitNodeStatus> filter) {
        this.filter = filter;
    }

    @Override
    public void accumulate(Entry item) {
        UnitNodeStatus status;
        byte[] value = item.value();
        if (value != null && this.filter.test(status = UnitNodeStatus.deserialize(value))) {
            this.nodes.add(status);
        }
    }

    @Override
    public List<UnitNodeStatus> get() throws AccumulateException {
        return this.nodes;
    }
}

