/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.checkpoint.s3.S3CheckpointData;
import org.apache.ignite.spi.checkpoint.s3.S3CheckpointSpiMBean;
import org.apache.ignite.spi.checkpoint.s3.S3TimeData;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
public class S3CheckpointSpi
extends IgniteSpiAdapter
implements CheckpointSpi {
    @LoggerResource
    private IgniteLogger log;
    @IgniteInstanceResource
    private Ignite ignite;
    private S3TimeoutWorker timeoutWrk;
    private CheckpointListener lsnr;
    public static final String BUCKET_NAME_PREFIX = "ignite-checkpoint-";
    public static final String DFLT_BUCKET_NAME_SUFFIX = "default-bucket";
    @GridToStringExclude
    private AmazonS3 s3;
    private String bucketNameSuffix;
    private String bucketName;
    @Nullable
    private String bucketEndpoint;
    @Nullable
    private String sseAlg;
    private ClientConfiguration cfg;
    @GridToStringExclude
    private AWSCredentials cred;
    private final Object mux = new Object();

    public String getBucketName() {
        return this.bucketName;
    }

    @Nullable
    public String getBucketEndpoint() {
        return this.bucketEndpoint;
    }

    @Nullable
    public String getSSEAlgorithm() {
        return this.sseAlg;
    }

    public String getAccessKey() {
        return this.cred.getAWSAccessKeyId();
    }

    public String getSecretAccessKey() {
        return this.cred.getAWSSecretKey();
    }

    public String getProxyHost() {
        return this.cfg.getProxyHost();
    }

    public int getProxyPort() {
        return this.cfg.getProxyPort();
    }

    public String getProxyUsername() {
        return this.cfg.getProxyUsername();
    }

    public String getProxyPassword() {
        return this.cfg.getProxyPassword();
    }

    @IgniteSpiConfiguration(optional=true)
    public S3CheckpointSpi setBucketNameSuffix(String bucketNameSuffix) {
        this.bucketNameSuffix = bucketNameSuffix;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public S3CheckpointSpi setBucketEndpoint(String bucketEndpoint) {
        this.bucketEndpoint = bucketEndpoint;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public S3CheckpointSpi setSSEAlgorithm(String sseAlg) {
        this.sseAlg = sseAlg;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public S3CheckpointSpi setClientConfiguration(ClientConfiguration cfg) {
        this.cfg = cfg;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public S3CheckpointSpi setAwsCredentials(AWSCredentials cred) {
        this.cred = cred;
        return this;
    }

    /*
     * Exception decompiling
     */
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void spiStop() throws IgniteSpiException {
        if (this.timeoutWrk != null) {
            IgniteUtils.interrupt((Thread)((Object)this.timeoutWrk));
            IgniteUtils.join((Thread)((Object)this.timeoutWrk), (IgniteLogger)this.log);
        }
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public byte[] loadCheckpoint(String key) throws IgniteSpiException {
        assert (!F.isEmpty((String)key));
        try {
            S3CheckpointData data = this.read(key);
            return data != null ? (Object)(data.getExpireTime() == 0L || data.getExpireTime() > U.currentTimeMillis() ? data.getState() : null) : null;
        }
        catch (AmazonClientException e) {
            throw new IgniteSpiException("Failed to read checkpoint key: " + key, (Throwable)e);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal/unmarshal objects in checkpoint key: " + key, (Throwable)e);
        }
    }

    public boolean saveCheckpoint(String key, byte[] state, long timeout, boolean overwrite) throws IgniteSpiException {
        assert (!F.isEmpty((String)key));
        long expireTime = 0L;
        if (timeout > 0L && (expireTime = U.currentTimeMillis() + timeout) < 0L) {
            expireTime = Long.MAX_VALUE;
        }
        try {
            if (this.hasKey(key)) {
                if (!overwrite) {
                    return false;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Overriding existing key: " + key);
                }
            }
            S3CheckpointData data = new S3CheckpointData(state, expireTime, key);
            this.write(data);
        }
        catch (AmazonClientException e) {
            throw new IgniteSpiException("Failed to write checkpoint data [key=" + key + ", state=" + Arrays.toString(state) + ']', (Throwable)e);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal checkpoint data [key=" + key + ", state=" + Arrays.toString(state) + ']', (Throwable)e);
        }
        if (timeout > 0L) {
            this.timeoutWrk.add(new S3TimeData(expireTime, key));
        }
        return true;
    }

    public boolean removeCheckpoint(String key) {
        CheckpointListener tmpLsnr;
        assert (!F.isEmpty((String)key));
        this.timeoutWrk.remove(key);
        boolean rmv = false;
        try {
            rmv = this.delete(key);
        }
        catch (AmazonClientException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to delete data by key: " + key), (Throwable)e);
        }
        if (rmv && (tmpLsnr = this.lsnr) != null) {
            tmpLsnr.onCheckpointRemoved(key);
        }
        return rmv;
    }

    @Nullable
    private S3CheckpointData read(String key) throws IgniteCheckedException, AmazonClientException {
        S3CheckpointData s3CheckpointData;
        assert (!F.isEmpty((String)key));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reading data from S3 [bucket=" + this.bucketName + ", key=" + key + ']');
        }
        S3Object obj = this.s3.getObject(this.bucketName, key);
        S3ObjectInputStream in = obj.getObjectContent();
        try {
            s3CheckpointData = S3CheckpointData.fromStream((InputStream)in);
        }
        catch (IOException e) {
            try {
                try {
                    throw new IgniteCheckedException("Failed to unmarshal S3CheckpointData [bucketName=" + this.bucketName + ", key=" + key + ']', (Throwable)e);
                }
                catch (Throwable throwable) {
                    U.closeQuiet((AutoCloseable)in);
                    throw throwable;
                }
            }
            catch (AmazonServiceException e2) {
                if (e2.getStatusCode() != 404) {
                    throw e2;
                }
                return null;
            }
        }
        U.closeQuiet((AutoCloseable)in);
        return s3CheckpointData;
    }

    private void write(S3CheckpointData data) throws IgniteCheckedException, AmazonClientException {
        assert (data != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing data to S3 [bucket=" + this.bucketName + ", key=" + data.getKey() + ']');
        }
        byte[] buf = data.toBytes();
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength((long)buf.length);
        if (!F.isEmpty((String)this.sseAlg)) {
            meta.setSSEAlgorithm(this.sseAlg);
        }
        this.s3.putObject(this.bucketName, data.getKey(), (InputStream)new ByteArrayInputStream(buf), meta);
    }

    private boolean delete(String key) throws AmazonClientException {
        assert (!F.isEmpty((String)key));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing data from S3 [bucket=" + this.bucketName + ", key=" + key + ']');
        }
        if (!this.hasKey(key)) {
            return false;
        }
        this.s3.deleteObject(this.bucketName, key);
        return true;
    }

    boolean hasKey(String key) throws AmazonClientException {
        assert (!F.isEmpty((String)key));
        try {
            return this.s3.getObjectMetadata(this.bucketName, key).getContentLength() != 0L;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    public void setCheckpointListener(CheckpointListener lsnr) {
        this.lsnr = lsnr;
    }

    public S3CheckpointSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(S3CheckpointSpi.class, (Object)((Object)this));
    }

    private class S3CheckpointSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements S3CheckpointSpiMBean {
        S3CheckpointSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public String getBucketName() {
            return S3CheckpointSpi.this.getBucketName();
        }

        @Override
        public String getBucketEndpoint() {
            return S3CheckpointSpi.this.getBucketName();
        }

        @Override
        public String getSSEAlgorithm() {
            return S3CheckpointSpi.this.getSSEAlgorithm();
        }

        @Override
        public String getAccessKey() {
            return S3CheckpointSpi.this.getAccessKey();
        }

        @Override
        public String getProxyHost() {
            return S3CheckpointSpi.this.getProxyHost();
        }

        @Override
        public int getProxyPort() {
            return S3CheckpointSpi.this.getProxyPort();
        }

        @Override
        public String getProxyUsername() {
            return S3CheckpointSpi.this.getProxyUsername();
        }
    }

    private class S3TimeoutWorker
    extends IgniteSpiThread {
        private Map<String, S3TimeData> map;

        S3TimeoutWorker() {
            super(S3CheckpointSpi.this.ignite.name(), "grid-s3-checkpoint-worker", S3CheckpointSpi.this.log);
            this.map = new HashMap<String, S3TimeData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void body() throws InterruptedException {
            Object object;
            long nextTime = 0L;
            HashSet<String> rmvKeys = new HashSet<String>();
            while (!this.isInterrupted()) {
                rmvKeys.clear();
                object = S3CheckpointSpi.this.mux;
                synchronized (object) {
                    long delay = U.currentTimeMillis() - nextTime;
                    if (nextTime != 0L && delay > 0L) {
                        S3CheckpointSpi.this.mux.wait(delay);
                    }
                    long now = U.currentTimeMillis();
                    nextTime = -1L;
                    Iterator<Map.Entry<String, S3TimeData>> iter = this.map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, S3TimeData> entry = iter.next();
                        String key = entry.getKey();
                        S3TimeData timeData = entry.getValue();
                        if (timeData.getExpireTime() <= 0L) continue;
                        if (timeData.getExpireTime() <= now) {
                            try {
                                S3CheckpointSpi.this.delete(key);
                                if (S3CheckpointSpi.this.log.isDebugEnabled()) {
                                    S3CheckpointSpi.this.log.debug("Data was deleted by timeout: " + key);
                                }
                            }
                            catch (AmazonClientException e) {
                                U.error((IgniteLogger)S3CheckpointSpi.this.log, (Object)("Failed to delete data by key: " + key), (Throwable)e);
                            }
                            iter.remove();
                            rmvKeys.add(timeData.getKey());
                            continue;
                        }
                        if (timeData.getExpireTime() >= nextTime && nextTime != -1L) continue;
                        nextTime = timeData.getExpireTime();
                    }
                }
                CheckpointListener tmpLsnr = S3CheckpointSpi.this.lsnr;
                if (tmpLsnr == null) continue;
                for (String key : rmvKeys) {
                    tmpLsnr.onCheckpointRemoved(key);
                }
            }
            object = S3CheckpointSpi.this.mux;
            synchronized (object) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(S3TimeData timeData) {
            assert (timeData != null);
            Object object = S3CheckpointSpi.this.mux;
            synchronized (object) {
                this.map.put(timeData.getKey(), timeData);
                S3CheckpointSpi.this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Iterable<S3TimeData> newData) {
            assert (newData != null);
            Object object = S3CheckpointSpi.this.mux;
            synchronized (object) {
                for (S3TimeData data : newData) {
                    this.map.put(data.getKey(), data);
                }
                S3CheckpointSpi.this.mux.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String key) {
            assert (key != null);
            Object object = S3CheckpointSpi.this.mux;
            synchronized (object) {
                this.map.remove(key);
            }
        }

        public String toString() {
            return S.toString(S3TimeoutWorker.class, (Object)((Object)this));
        }
    }
}

