/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.direct.state.DirectMessageState;
import org.apache.ignite.internal.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.direct.stream.v1.DirectByteBufferStreamImplV1;
import org.apache.ignite.internal.direct.stream.v2.DirectByteBufferStreamImplV2;
import org.apache.ignite.internal.direct.stream.v3.DirectByteBufferStreamImplV3;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.jetbrains.annotations.Nullable;

public class DirectMessageReader
implements MessageReader {
    @GridToStringInclude
    private final DirectMessageState<StateItem> state;
    @GridToStringInclude
    private final byte protoVer;
    private boolean lastRead;

    public DirectMessageReader(final MessageFactory msgFactory, final byte protoVer) {
        this.state = new DirectMessageState<StateItem>(StateItem.class, new IgniteOutClosure<StateItem>(){

            @Override
            public StateItem apply() {
                return new StateItem(msgFactory, protoVer);
            }
        });
        this.protoVer = protoVer;
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        this.state.item().stream.setBuffer(buf);
    }

    @Override
    public void setCurrentReadClass(Class<? extends Message> msgCls) {
    }

    @Override
    public boolean beforeMessageRead() {
        return true;
    }

    @Override
    public boolean afterMessageRead(Class<? extends Message> msgCls) {
        return true;
    }

    @Override
    public byte readByte(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        byte val = stream.readByte();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public short readShort(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        short val = stream.readShort();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public int readInt(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        int val = stream.readInt();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public int readInt(String name, int dflt) {
        return this.readInt(name);
    }

    @Override
    public long readLong(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        long val = stream.readLong();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public float readFloat(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        float val = stream.readFloat();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public double readDouble(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        double val = stream.readDouble();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public char readChar(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        char val = stream.readChar();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public boolean readBoolean(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        boolean val = stream.readBoolean();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    @Nullable
    public byte[] readByteArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        byte[] arr = stream.readByteArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public short[] readShortArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        short[] arr = stream.readShortArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public int[] readIntArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        int[] arr = stream.readIntArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public long[] readLongArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        long[] arr = stream.readLongArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public float[] readFloatArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        float[] arr = stream.readFloatArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public double[] readDoubleArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        double[] arr = stream.readDoubleArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public char[] readCharArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        char[] arr = stream.readCharArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        boolean[] arr = stream.readBooleanArray();
        this.lastRead = stream.lastFinished();
        return arr;
    }

    @Override
    public String readString(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        String val = stream.readString();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public BitSet readBitSet(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        BitSet val = stream.readBitSet();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public UUID readUuid(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        UUID val = stream.readUuid();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public IgniteUuid readIgniteUuid(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        IgniteUuid val = stream.readIgniteUuid();
        this.lastRead = stream.lastFinished();
        return val;
    }

    @Override
    public AffinityTopologyVersion readAffinityTopologyVersion(String name) {
        if (this.protoVer >= 3) {
            DirectByteBufferStream stream = this.state.item().stream;
            AffinityTopologyVersion val = stream.readAffinityTopologyVersion();
            this.lastRead = stream.lastFinished();
            return val;
        }
        return (AffinityTopologyVersion)this.readMessage(name);
    }

    @Override
    @Nullable
    public <T extends Message> T readMessage(String name) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object msg = stream.readMessage(this);
        this.lastRead = stream.lastFinished();
        return msg;
    }

    @Override
    public <T> T[] readObjectArray(String name, MessageCollectionItemType itemType, Class<T> itemCls) {
        DirectByteBufferStream stream = this.state.item().stream;
        T[] msg = stream.readObjectArray(itemType, itemCls, this);
        this.lastRead = stream.lastFinished();
        return msg;
    }

    @Override
    public <C extends Collection<?>> C readCollection(String name, MessageCollectionItemType itemType) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object col = stream.readCollection(itemType, this);
        this.lastRead = stream.lastFinished();
        return col;
    }

    @Override
    public <M extends Map<?, ?>> M readMap(String name, MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked) {
        DirectByteBufferStream stream = this.state.item().stream;
        Object map = stream.readMap(keyType, valType, linked, this);
        this.lastRead = stream.lastFinished();
        return map;
    }

    @Override
    public boolean isLastRead() {
        return this.lastRead;
    }

    @Override
    public int state() {
        return this.state.item().state;
    }

    @Override
    public void incrementState() {
        this.state.item().state++;
    }

    @Override
    public void beforeInnerMessageRead() {
        this.state.forward();
    }

    @Override
    public void afterInnerMessageRead(boolean finished) {
        this.state.backward(finished);
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    public String toString() {
        return S.toString(DirectMessageReader.class, this);
    }

    private static class StateItem
    implements DirectMessageStateItem {
        private final DirectByteBufferStream stream;
        private int state;

        public StateItem(MessageFactory msgFactory, byte protoVer) {
            switch (protoVer) {
                case 1: {
                    this.stream = new DirectByteBufferStreamImplV1(msgFactory);
                    break;
                }
                case 2: {
                    this.stream = new DirectByteBufferStreamImplV2(msgFactory);
                    break;
                }
                case 3: {
                    this.stream = new DirectByteBufferStreamImplV3(msgFactory);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid protocol version: " + protoVer);
                }
            }
        }

        @Override
        public void reset() {
            this.state = 0;
        }

        public String toString() {
            return S.toString(StateItem.class, this);
        }
    }
}

