/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.actions.BaseDeleteOrphanFiles;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseDeleteOrphanFiles", generator="Immutables")
public final class ImmutableDeleteOrphanFiles {
    private ImmutableDeleteOrphanFiles() {
    }

    @CheckReturnValue
    @Generated(from="BaseDeleteOrphanFiles.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseDeleteOrphanFiles.Result {
        private final Iterable<String> orphanFileLocations;

        private Result(Iterable<String> orphanFileLocations) {
            this.orphanFileLocations = orphanFileLocations;
        }

        public Iterable<String> orphanFileLocations() {
            return this.orphanFileLocations;
        }

        public final Result withOrphanFileLocations(Iterable<String> value) {
            if (this.orphanFileLocations == value) {
                return this;
            }
            Iterable<String> newValue = Objects.requireNonNull(value, "orphanFileLocations");
            return new Result(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalsByValue((Result)another);
        }

        private boolean equalsByValue(Result another) {
            return this.orphanFileLocations.equals(another.orphanFileLocations);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.orphanFileLocations.hashCode();
            return h;
        }

        public String toString() {
            return "Result{orphanFileLocations=" + String.valueOf(this.orphanFileLocations) + "}";
        }

        public static Result copyOf(BaseDeleteOrphanFiles.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseDeleteOrphanFiles.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_ORPHAN_FILE_LOCATIONS = 1L;
            private long initBits = 1L;
            @Nullable
            private Iterable<String> orphanFileLocations;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseDeleteOrphanFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(DeleteOrphanFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                BaseDeleteOrphanFiles.Result instance;
                long bits = 0L;
                if (object instanceof BaseDeleteOrphanFiles.Result) {
                    instance = (BaseDeleteOrphanFiles.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.orphanFileLocations(instance.orphanFileLocations());
                        bits |= 1L;
                    }
                }
                if (object instanceof DeleteOrphanFiles.Result) {
                    instance = (DeleteOrphanFiles.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.orphanFileLocations(instance.orphanFileLocations());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder orphanFileLocations(Iterable<String> orphanFileLocations) {
                this.orphanFileLocations = Objects.requireNonNull(orphanFileLocations, "orphanFileLocations");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Result build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Result(this.orphanFileLocations);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("orphanFileLocations");
                }
                return "Cannot build Result, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

