/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.BaseRewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseRewriteDataFiles", generator="Immutables")
public final class ImmutableRewriteDataFiles {
    private ImmutableRewriteDataFiles() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupInfo", generator="Immutables")
    @Immutable
    public static final class FileGroupInfo
    implements BaseRewriteDataFiles.FileGroupInfo {
        private final int globalIndex;
        private final int partitionIndex;
        private final StructLike partition;

        private FileGroupInfo(int globalIndex, int partitionIndex, StructLike partition) {
            this.globalIndex = globalIndex;
            this.partitionIndex = partitionIndex;
            this.partition = partition;
        }

        public int globalIndex() {
            return this.globalIndex;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public StructLike partition() {
            return this.partition;
        }

        public final FileGroupInfo withGlobalIndex(int value) {
            if (this.globalIndex == value) {
                return this;
            }
            return new FileGroupInfo(value, this.partitionIndex, this.partition);
        }

        public final FileGroupInfo withPartitionIndex(int value) {
            if (this.partitionIndex == value) {
                return this;
            }
            return new FileGroupInfo(this.globalIndex, value, this.partition);
        }

        public final FileGroupInfo withPartition(StructLike value) {
            if (this.partition == value) {
                return this;
            }
            StructLike newValue = Objects.requireNonNull(value, "partition");
            return new FileGroupInfo(this.globalIndex, this.partitionIndex, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupInfo && this.equalsByValue((FileGroupInfo)another);
        }

        private boolean equalsByValue(FileGroupInfo another) {
            return this.globalIndex == another.globalIndex && this.partitionIndex == another.partitionIndex && this.partition.equals(another.partition);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.globalIndex;
            h += (h << 5) + this.partitionIndex;
            h += (h << 5) + this.partition.hashCode();
            return h;
        }

        public String toString() {
            return "FileGroupInfo{globalIndex=" + this.globalIndex + ", partitionIndex=" + this.partitionIndex + ", partition=" + String.valueOf(this.partition) + "}";
        }

        public static FileGroupInfo copyOf(BaseRewriteDataFiles.FileGroupInfo instance) {
            if (instance instanceof FileGroupInfo) {
                return (FileGroupInfo)instance;
            }
            return FileGroupInfo.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupInfo", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_GLOBAL_INDEX = 1L;
            private static final long INIT_BIT_PARTITION_INDEX = 2L;
            private static final long INIT_BIT_PARTITION = 4L;
            private long initBits = 7L;
            private int globalIndex;
            private int partitionIndex;
            @Nullable
            private StructLike partition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                BaseRewriteDataFiles.FileGroupInfo instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupInfo) {
                    instance = (BaseRewriteDataFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupInfo) {
                    instance = (RewriteDataFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder globalIndex(int globalIndex) {
                this.globalIndex = globalIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partitionIndex(int partitionIndex) {
                this.partitionIndex = partitionIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partition(StructLike partition) {
                this.partition = Objects.requireNonNull(partition, "partition");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public FileGroupInfo build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupInfo(this.globalIndex, this.partitionIndex, this.partition);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("globalIndex");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("partitionIndex");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("partition");
                }
                return "Cannot build FileGroupInfo, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupFailureResult", generator="Immutables")
    @Immutable
    public static final class FileGroupFailureResult
    implements BaseRewriteDataFiles.FileGroupFailureResult {
        private final RewriteDataFiles.FileGroupInfo info;
        private final int dataFilesCount;

        private FileGroupFailureResult(RewriteDataFiles.FileGroupInfo info, int dataFilesCount) {
            this.info = info;
            this.dataFilesCount = dataFilesCount;
        }

        public RewriteDataFiles.FileGroupInfo info() {
            return this.info;
        }

        public int dataFilesCount() {
            return this.dataFilesCount;
        }

        public final FileGroupFailureResult withInfo(RewriteDataFiles.FileGroupInfo value) {
            if (this.info == value) {
                return this;
            }
            RewriteDataFiles.FileGroupInfo newValue = Objects.requireNonNull(value, "info");
            return new FileGroupFailureResult(newValue, this.dataFilesCount);
        }

        public final FileGroupFailureResult withDataFilesCount(int value) {
            if (this.dataFilesCount == value) {
                return this;
            }
            return new FileGroupFailureResult(this.info, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupFailureResult && this.equalsByValue((FileGroupFailureResult)another);
        }

        private boolean equalsByValue(FileGroupFailureResult another) {
            return this.info.equals(another.info) && this.dataFilesCount == another.dataFilesCount;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.info.hashCode();
            h += (h << 5) + this.dataFilesCount;
            return h;
        }

        public String toString() {
            return "FileGroupFailureResult{info=" + String.valueOf(this.info) + ", dataFilesCount=" + this.dataFilesCount + "}";
        }

        public static FileGroupFailureResult copyOf(BaseRewriteDataFiles.FileGroupFailureResult instance) {
            if (instance instanceof FileGroupFailureResult) {
                return (FileGroupFailureResult)instance;
            }
            return FileGroupFailureResult.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupFailureResult", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INFO = 1L;
            private static final long INIT_BIT_DATA_FILES_COUNT = 2L;
            private long initBits = 3L;
            @Nullable
            private RewriteDataFiles.FileGroupInfo info;
            private int dataFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupFailureResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupFailureResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                BaseRewriteDataFiles.FileGroupFailureResult instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupFailureResult) {
                    instance = (BaseRewriteDataFiles.FileGroupFailureResult)object;
                    if ((bits & 1L) == 0L) {
                        this.dataFilesCount(instance.dataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.info(instance.info());
                        bits |= 2L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupFailureResult) {
                    instance = (RewriteDataFiles.FileGroupFailureResult)object;
                    if ((bits & 1L) == 0L) {
                        this.dataFilesCount(instance.dataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.info(instance.info());
                        bits |= 2L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder info(RewriteDataFiles.FileGroupInfo info) {
                this.info = Objects.requireNonNull(info, "info");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder dataFilesCount(int dataFilesCount) {
                this.dataFilesCount = dataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FileGroupFailureResult build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupFailureResult(this.info, this.dataFilesCount);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("info");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("dataFilesCount");
                }
                return "Cannot build FileGroupFailureResult, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.FileGroupRewriteResult", generator="Immutables")
    @Immutable
    public static final class FileGroupRewriteResult
    implements BaseRewriteDataFiles.FileGroupRewriteResult {
        private final RewriteDataFiles.FileGroupInfo info;
        private final int addedDataFilesCount;
        private final int rewrittenDataFilesCount;
        private final long rewrittenBytesCount;
        private final int removedDeleteFilesCount;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private FileGroupRewriteResult(Builder builder) {
            this.info = builder.info;
            this.addedDataFilesCount = builder.addedDataFilesCount;
            this.rewrittenDataFilesCount = builder.rewrittenDataFilesCount;
            if (builder.rewrittenBytesCountIsSet()) {
                this.initShim.rewrittenBytesCount(builder.rewrittenBytesCount);
            }
            if (builder.removedDeleteFilesCountIsSet()) {
                this.initShim.removedDeleteFilesCount(builder.removedDeleteFilesCount);
            }
            this.rewrittenBytesCount = this.initShim.rewrittenBytesCount();
            this.removedDeleteFilesCount = this.initShim.removedDeleteFilesCount();
            this.initShim = null;
        }

        private FileGroupRewriteResult(RewriteDataFiles.FileGroupInfo info, int addedDataFilesCount, int rewrittenDataFilesCount, long rewrittenBytesCount, int removedDeleteFilesCount) {
            this.info = info;
            this.addedDataFilesCount = addedDataFilesCount;
            this.rewrittenDataFilesCount = rewrittenDataFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
            this.removedDeleteFilesCount = removedDeleteFilesCount;
            this.initShim = null;
        }

        private long rewrittenBytesCountInitialize() {
            return BaseRewriteDataFiles.FileGroupRewriteResult.super.rewrittenBytesCount();
        }

        private int removedDeleteFilesCountInitialize() {
            return BaseRewriteDataFiles.FileGroupRewriteResult.super.removedDeleteFilesCount();
        }

        public RewriteDataFiles.FileGroupInfo info() {
            return this.info;
        }

        public int addedDataFilesCount() {
            return this.addedDataFilesCount;
        }

        public int rewrittenDataFilesCount() {
            return this.rewrittenDataFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenBytesCount() : this.rewrittenBytesCount;
        }

        @Override
        public int removedDeleteFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.removedDeleteFilesCount() : this.removedDeleteFilesCount;
        }

        public final FileGroupRewriteResult withInfo(RewriteDataFiles.FileGroupInfo value) {
            if (this.info == value) {
                return this;
            }
            RewriteDataFiles.FileGroupInfo newValue = Objects.requireNonNull(value, "info");
            return new FileGroupRewriteResult(newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount);
        }

        public final FileGroupRewriteResult withAddedDataFilesCount(int value) {
            if (this.addedDataFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, value, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount);
        }

        public final FileGroupRewriteResult withRewrittenDataFilesCount(int value) {
            if (this.rewrittenDataFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.addedDataFilesCount, value, this.rewrittenBytesCount, this.removedDeleteFilesCount);
        }

        public final FileGroupRewriteResult withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.addedDataFilesCount, this.rewrittenDataFilesCount, value, this.removedDeleteFilesCount);
        }

        public final FileGroupRewriteResult withRemovedDeleteFilesCount(int value) {
            if (this.removedDeleteFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupRewriteResult && this.equalsByValue((FileGroupRewriteResult)another);
        }

        private boolean equalsByValue(FileGroupRewriteResult another) {
            return this.info.equals(another.info) && this.addedDataFilesCount == another.addedDataFilesCount && this.rewrittenDataFilesCount == another.rewrittenDataFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount && this.removedDeleteFilesCount == another.removedDeleteFilesCount;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.info.hashCode();
            h += (h << 5) + this.addedDataFilesCount;
            h += (h << 5) + this.rewrittenDataFilesCount;
            h += (h << 5) + Long.hashCode(this.rewrittenBytesCount);
            h += (h << 5) + this.removedDeleteFilesCount;
            return h;
        }

        public String toString() {
            return "FileGroupRewriteResult{info=" + String.valueOf(this.info) + ", addedDataFilesCount=" + this.addedDataFilesCount + ", rewrittenDataFilesCount=" + this.rewrittenDataFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + ", removedDeleteFilesCount=" + this.removedDeleteFilesCount + "}";
        }

        public static FileGroupRewriteResult copyOf(BaseRewriteDataFiles.FileGroupRewriteResult instance) {
            if (instance instanceof FileGroupRewriteResult) {
                return (FileGroupRewriteResult)instance;
            }
            return FileGroupRewriteResult.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupRewriteResult", generator="Immutables")
        private final class InitShim {
            private byte rewrittenBytesCountBuildStage = 0;
            private long rewrittenBytesCount;
            private byte removedDeleteFilesCountBuildStage = 0;
            private int removedDeleteFilesCount;

            private InitShim() {
            }

            long rewrittenBytesCount() {
                if (this.rewrittenBytesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenBytesCountBuildStage == 0) {
                    long computedValue;
                    this.rewrittenBytesCountBuildStage = (byte)-1;
                    this.rewrittenBytesCount = computedValue = FileGroupRewriteResult.this.rewrittenBytesCountInitialize();
                    this.rewrittenBytesCountBuildStage = 1;
                }
                return this.rewrittenBytesCount;
            }

            void rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.rewrittenBytesCountBuildStage = 1;
            }

            int removedDeleteFilesCount() {
                if (this.removedDeleteFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.removedDeleteFilesCountBuildStage == 0) {
                    int computedValue;
                    this.removedDeleteFilesCountBuildStage = (byte)-1;
                    this.removedDeleteFilesCount = computedValue = FileGroupRewriteResult.this.removedDeleteFilesCountInitialize();
                    this.removedDeleteFilesCountBuildStage = 1;
                }
                return this.removedDeleteFilesCount;
            }

            void removedDeleteFilesCount(int removedDeleteFilesCount) {
                this.removedDeleteFilesCount = removedDeleteFilesCount;
                this.removedDeleteFilesCountBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.rewrittenBytesCountBuildStage == -1) {
                    attributes.add("rewrittenBytesCount");
                }
                if (this.removedDeleteFilesCountBuildStage == -1) {
                    attributes.add("removedDeleteFilesCount");
                }
                return "Cannot build FileGroupRewriteResult, attribute initializers form cycle " + String.valueOf(attributes);
            }
        }

        @Generated(from="BaseRewriteDataFiles.FileGroupRewriteResult", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INFO = 1L;
            private static final long INIT_BIT_ADDED_DATA_FILES_COUNT = 2L;
            private static final long INIT_BIT_REWRITTEN_DATA_FILES_COUNT = 4L;
            private static final long OPT_BIT_REWRITTEN_BYTES_COUNT = 1L;
            private static final long OPT_BIT_REMOVED_DELETE_FILES_COUNT = 2L;
            private long initBits = 7L;
            private long optBits;
            @Nullable
            private RewriteDataFiles.FileGroupInfo info;
            private int addedDataFilesCount;
            private int rewrittenDataFilesCount;
            private long rewrittenBytesCount;
            private int removedDeleteFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                BaseRewriteDataFiles.FileGroupRewriteResult instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.FileGroupRewriteResult) {
                    instance = (BaseRewriteDataFiles.FileGroupRewriteResult)object;
                    if ((bits & 1L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.removedDeleteFilesCount(instance.removedDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.info(instance.info());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof RewriteDataFiles.FileGroupRewriteResult) {
                    instance = (RewriteDataFiles.FileGroupRewriteResult)object;
                    if ((bits & 1L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.removedDeleteFilesCount(instance.removedDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.info(instance.info());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder info(RewriteDataFiles.FileGroupInfo info) {
                this.info = Objects.requireNonNull(info, "info");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder removedDeleteFilesCount(int removedDeleteFilesCount) {
                this.removedDeleteFilesCount = removedDeleteFilesCount;
                this.optBits |= 2L;
                return this;
            }

            public FileGroupRewriteResult build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupRewriteResult(this);
            }

            private boolean rewrittenBytesCountIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean removedDeleteFilesCountIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("info");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("addedDataFilesCount");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("rewrittenDataFilesCount");
                }
                return "Cannot build FileGroupRewriteResult, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseRewriteDataFiles.Result {
        private final List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults;
        private final List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures;
        private final int addedDataFilesCount;
        private final int rewrittenDataFilesCount;
        private final long rewrittenBytesCount;
        private final int removedDeleteFilesCount;
        private final int failedDataFilesCount;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Result(Builder builder) {
            this.rewriteResults = ImmutableRewriteDataFiles.createUnmodifiableList(true, builder.rewriteResults);
            if (builder.rewriteFailuresIsSet()) {
                this.initShim.rewriteFailures(ImmutableRewriteDataFiles.createUnmodifiableList(true, builder.rewriteFailures));
            }
            if (builder.addedDataFilesCountIsSet()) {
                this.initShim.addedDataFilesCount(builder.addedDataFilesCount);
            }
            if (builder.rewrittenDataFilesCountIsSet()) {
                this.initShim.rewrittenDataFilesCount(builder.rewrittenDataFilesCount);
            }
            if (builder.rewrittenBytesCountIsSet()) {
                this.initShim.rewrittenBytesCount(builder.rewrittenBytesCount);
            }
            if (builder.removedDeleteFilesCountIsSet()) {
                this.initShim.removedDeleteFilesCount(builder.removedDeleteFilesCount);
            }
            if (builder.failedDataFilesCountIsSet()) {
                this.initShim.failedDataFilesCount(builder.failedDataFilesCount);
            }
            this.rewriteFailures = this.initShim.rewriteFailures();
            this.addedDataFilesCount = this.initShim.addedDataFilesCount();
            this.rewrittenDataFilesCount = this.initShim.rewrittenDataFilesCount();
            this.rewrittenBytesCount = this.initShim.rewrittenBytesCount();
            this.removedDeleteFilesCount = this.initShim.removedDeleteFilesCount();
            this.failedDataFilesCount = this.initShim.failedDataFilesCount();
            this.initShim = null;
        }

        private Result(List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults, List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures, int addedDataFilesCount, int rewrittenDataFilesCount, long rewrittenBytesCount, int removedDeleteFilesCount, int failedDataFilesCount) {
            this.rewriteResults = rewriteResults;
            this.rewriteFailures = rewriteFailures;
            this.addedDataFilesCount = addedDataFilesCount;
            this.rewrittenDataFilesCount = rewrittenDataFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
            this.removedDeleteFilesCount = removedDeleteFilesCount;
            this.failedDataFilesCount = failedDataFilesCount;
            this.initShim = null;
        }

        private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailuresInitialize() {
            return BaseRewriteDataFiles.Result.super.rewriteFailures();
        }

        private int addedDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.addedDataFilesCount();
        }

        private int rewrittenDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.rewrittenDataFilesCount();
        }

        private long rewrittenBytesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.rewrittenBytesCount();
        }

        private int removedDeleteFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.removedDeleteFilesCount();
        }

        private int failedDataFilesCountInitialize() {
            return BaseRewriteDataFiles.Result.super.failedDataFilesCount();
        }

        public List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults() {
            return this.rewriteResults;
        }

        @Override
        public List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewriteFailures() : this.rewriteFailures;
        }

        @Override
        public int addedDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.addedDataFilesCount() : this.addedDataFilesCount;
        }

        @Override
        public int rewrittenDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenDataFilesCount() : this.rewrittenDataFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenBytesCount() : this.rewrittenBytesCount;
        }

        @Override
        public int removedDeleteFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.removedDeleteFilesCount() : this.removedDeleteFilesCount;
        }

        @Override
        public int failedDataFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.failedDataFilesCount() : this.failedDataFilesCount;
        }

        public final Result withRewriteResults(RewriteDataFiles.FileGroupRewriteResult ... elements) {
            List<RewriteDataFiles.FileGroupRewriteResult> newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(Arrays.asList(elements), true, false));
            return new Result(newValue, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
            if (this.rewriteResults == elements) {
                return this;
            }
            List<RewriteDataFiles.FileGroupRewriteResult> newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(elements, true, false));
            return new Result(newValue, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteFailures(RewriteDataFiles.FileGroupFailureResult ... elements) {
            List<RewriteDataFiles.FileGroupFailureResult> newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(Arrays.asList(elements), true, false));
            return new Result(this.rewriteResults, newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
            if (this.rewriteFailures == elements) {
                return this;
            }
            List<RewriteDataFiles.FileGroupFailureResult> newValue = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(elements, true, false));
            return new Result(this.rewriteResults, newValue, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withAddedDataFilesCount(int value) {
            if (this.addedDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, value, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRewrittenDataFilesCount(int value) {
            if (this.rewrittenDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, value, this.rewrittenBytesCount, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, value, this.removedDeleteFilesCount, this.failedDataFilesCount);
        }

        public final Result withRemovedDeleteFilesCount(int value) {
            if (this.removedDeleteFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, value, this.failedDataFilesCount);
        }

        public final Result withFailedDataFilesCount(int value) {
            if (this.failedDataFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewriteFailures, this.addedDataFilesCount, this.rewrittenDataFilesCount, this.rewrittenBytesCount, this.removedDeleteFilesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalsByValue((Result)another);
        }

        private boolean equalsByValue(Result another) {
            return this.rewriteResults.equals(another.rewriteResults) && this.rewriteFailures.equals(another.rewriteFailures) && this.addedDataFilesCount == another.addedDataFilesCount && this.rewrittenDataFilesCount == another.rewrittenDataFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount && this.removedDeleteFilesCount == another.removedDeleteFilesCount && this.failedDataFilesCount == another.failedDataFilesCount;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.rewriteResults.hashCode();
            h += (h << 5) + this.rewriteFailures.hashCode();
            h += (h << 5) + this.addedDataFilesCount;
            h += (h << 5) + this.rewrittenDataFilesCount;
            h += (h << 5) + Long.hashCode(this.rewrittenBytesCount);
            h += (h << 5) + this.removedDeleteFilesCount;
            h += (h << 5) + this.failedDataFilesCount;
            return h;
        }

        public String toString() {
            return "Result{rewriteResults=" + String.valueOf(this.rewriteResults) + ", rewriteFailures=" + String.valueOf(this.rewriteFailures) + ", addedDataFilesCount=" + this.addedDataFilesCount + ", rewrittenDataFilesCount=" + this.rewrittenDataFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + ", removedDeleteFilesCount=" + this.removedDeleteFilesCount + ", failedDataFilesCount=" + this.failedDataFilesCount + "}";
        }

        public static Result copyOf(BaseRewriteDataFiles.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
        private final class InitShim {
            private byte rewriteFailuresBuildStage = 0;
            private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures;
            private byte addedDataFilesCountBuildStage = 0;
            private int addedDataFilesCount;
            private byte rewrittenDataFilesCountBuildStage = 0;
            private int rewrittenDataFilesCount;
            private byte rewrittenBytesCountBuildStage = 0;
            private long rewrittenBytesCount;
            private byte removedDeleteFilesCountBuildStage = 0;
            private int removedDeleteFilesCount;
            private byte failedDataFilesCountBuildStage = 0;
            private int failedDataFilesCount;

            private InitShim() {
            }

            List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures() {
                if (this.rewriteFailuresBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewriteFailuresBuildStage == 0) {
                    this.rewriteFailuresBuildStage = (byte)-1;
                    List<RewriteDataFiles.FileGroupFailureResult> computedValue = Result.this.rewriteFailuresInitialize();
                    this.rewriteFailures = ImmutableRewriteDataFiles.createUnmodifiableList(false, ImmutableRewriteDataFiles.createSafeList(computedValue, true, false));
                    this.rewriteFailuresBuildStage = 1;
                }
                return this.rewriteFailures;
            }

            void rewriteFailures(List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures) {
                this.rewriteFailures = rewriteFailures;
                this.rewriteFailuresBuildStage = 1;
            }

            int addedDataFilesCount() {
                if (this.addedDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.addedDataFilesCountBuildStage == 0) {
                    int computedValue;
                    this.addedDataFilesCountBuildStage = (byte)-1;
                    this.addedDataFilesCount = computedValue = Result.this.addedDataFilesCountInitialize();
                    this.addedDataFilesCountBuildStage = 1;
                }
                return this.addedDataFilesCount;
            }

            void addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.addedDataFilesCountBuildStage = 1;
            }

            int rewrittenDataFilesCount() {
                if (this.rewrittenDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenDataFilesCountBuildStage == 0) {
                    int computedValue;
                    this.rewrittenDataFilesCountBuildStage = (byte)-1;
                    this.rewrittenDataFilesCount = computedValue = Result.this.rewrittenDataFilesCountInitialize();
                    this.rewrittenDataFilesCountBuildStage = 1;
                }
                return this.rewrittenDataFilesCount;
            }

            void rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.rewrittenDataFilesCountBuildStage = 1;
            }

            long rewrittenBytesCount() {
                if (this.rewrittenBytesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenBytesCountBuildStage == 0) {
                    long computedValue;
                    this.rewrittenBytesCountBuildStage = (byte)-1;
                    this.rewrittenBytesCount = computedValue = Result.this.rewrittenBytesCountInitialize();
                    this.rewrittenBytesCountBuildStage = 1;
                }
                return this.rewrittenBytesCount;
            }

            void rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.rewrittenBytesCountBuildStage = 1;
            }

            int removedDeleteFilesCount() {
                if (this.removedDeleteFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.removedDeleteFilesCountBuildStage == 0) {
                    int computedValue;
                    this.removedDeleteFilesCountBuildStage = (byte)-1;
                    this.removedDeleteFilesCount = computedValue = Result.this.removedDeleteFilesCountInitialize();
                    this.removedDeleteFilesCountBuildStage = 1;
                }
                return this.removedDeleteFilesCount;
            }

            void removedDeleteFilesCount(int removedDeleteFilesCount) {
                this.removedDeleteFilesCount = removedDeleteFilesCount;
                this.removedDeleteFilesCountBuildStage = 1;
            }

            int failedDataFilesCount() {
                if (this.failedDataFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.failedDataFilesCountBuildStage == 0) {
                    int computedValue;
                    this.failedDataFilesCountBuildStage = (byte)-1;
                    this.failedDataFilesCount = computedValue = Result.this.failedDataFilesCountInitialize();
                    this.failedDataFilesCountBuildStage = 1;
                }
                return this.failedDataFilesCount;
            }

            void failedDataFilesCount(int failedDataFilesCount) {
                this.failedDataFilesCount = failedDataFilesCount;
                this.failedDataFilesCountBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.rewriteFailuresBuildStage == -1) {
                    attributes.add("rewriteFailures");
                }
                if (this.addedDataFilesCountBuildStage == -1) {
                    attributes.add("addedDataFilesCount");
                }
                if (this.rewrittenDataFilesCountBuildStage == -1) {
                    attributes.add("rewrittenDataFilesCount");
                }
                if (this.rewrittenBytesCountBuildStage == -1) {
                    attributes.add("rewrittenBytesCount");
                }
                if (this.removedDeleteFilesCountBuildStage == -1) {
                    attributes.add("removedDeleteFilesCount");
                }
                if (this.failedDataFilesCountBuildStage == -1) {
                    attributes.add("failedDataFilesCount");
                }
                return "Cannot build Result, attribute initializers form cycle " + String.valueOf(attributes);
            }
        }

        @Generated(from="BaseRewriteDataFiles.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_REWRITE_FAILURES = 1L;
            private static final long OPT_BIT_ADDED_DATA_FILES_COUNT = 2L;
            private static final long OPT_BIT_REWRITTEN_DATA_FILES_COUNT = 4L;
            private static final long OPT_BIT_REWRITTEN_BYTES_COUNT = 8L;
            private static final long OPT_BIT_REMOVED_DELETE_FILES_COUNT = 16L;
            private static final long OPT_BIT_FAILED_DATA_FILES_COUNT = 32L;
            private long optBits;
            private List<RewriteDataFiles.FileGroupRewriteResult> rewriteResults = new ArrayList<RewriteDataFiles.FileGroupRewriteResult>();
            private List<RewriteDataFiles.FileGroupFailureResult> rewriteFailures = new ArrayList<RewriteDataFiles.FileGroupFailureResult>();
            private int addedDataFilesCount;
            private int rewrittenDataFilesCount;
            private long rewrittenBytesCount;
            private int removedDeleteFilesCount;
            private int failedDataFilesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewriteDataFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewriteDataFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                BaseRewriteDataFiles.Result instance;
                long bits = 0L;
                if (object instanceof BaseRewriteDataFiles.Result) {
                    instance = (BaseRewriteDataFiles.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.failedDataFilesCount(instance.failedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllRewriteFailures(instance.rewriteFailures());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.removedDeleteFilesCount(instance.removedDeleteFilesCount());
                        bits |= 0x20L;
                    }
                    if ((bits & 0x40L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x40L;
                    }
                }
                if (object instanceof RewriteDataFiles.Result) {
                    instance = (RewriteDataFiles.Result)object;
                    if ((bits & 1L) == 0L) {
                        this.failedDataFilesCount(instance.failedDataFilesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addAllRewriteFailures(instance.rewriteFailures());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.addedDataFilesCount(instance.addedDataFilesCount());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenDataFilesCount(instance.rewrittenDataFilesCount());
                        bits |= 0x10L;
                    }
                    if ((bits & 0x20L) == 0L) {
                        this.removedDeleteFilesCount(instance.removedDeleteFilesCount());
                        bits |= 0x20L;
                    }
                    if ((bits & 0x40L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x40L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewriteDataFiles.FileGroupRewriteResult element) {
                this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewriteDataFiles.FileGroupRewriteResult ... elements) {
                for (RewriteDataFiles.FileGroupRewriteResult element : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
                this.rewriteResults.clear();
                return this.addAllRewriteResults(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllRewriteResults(Iterable<? extends RewriteDataFiles.FileGroupRewriteResult> elements) {
                for (RewriteDataFiles.FileGroupRewriteResult fileGroupRewriteResult : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(fileGroupRewriteResult, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteFailures(RewriteDataFiles.FileGroupFailureResult element) {
                this.rewriteFailures.add(Objects.requireNonNull(element, "rewriteFailures element"));
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteFailures(RewriteDataFiles.FileGroupFailureResult ... elements) {
                for (RewriteDataFiles.FileGroupFailureResult element : elements) {
                    this.rewriteFailures.add(Objects.requireNonNull(element, "rewriteFailures element"));
                }
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
                this.rewriteFailures.clear();
                return this.addAllRewriteFailures(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllRewriteFailures(Iterable<? extends RewriteDataFiles.FileGroupFailureResult> elements) {
                for (RewriteDataFiles.FileGroupFailureResult fileGroupFailureResult : elements) {
                    this.rewriteFailures.add(Objects.requireNonNull(fileGroupFailureResult, "rewriteFailures element"));
                }
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDataFilesCount(int addedDataFilesCount) {
                this.addedDataFilesCount = addedDataFilesCount;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDataFilesCount(int rewrittenDataFilesCount) {
                this.rewrittenDataFilesCount = rewrittenDataFilesCount;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder removedDeleteFilesCount(int removedDeleteFilesCount) {
                this.removedDeleteFilesCount = removedDeleteFilesCount;
                this.optBits |= 0x10L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder failedDataFilesCount(int failedDataFilesCount) {
                this.failedDataFilesCount = failedDataFilesCount;
                this.optBits |= 0x20L;
                return this;
            }

            public Result build() {
                return new Result(this);
            }

            private boolean rewriteFailuresIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean addedDataFilesCountIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean rewrittenDataFilesCountIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean rewrittenBytesCountIsSet() {
                return (this.optBits & 8L) != 0L;
            }

            private boolean removedDeleteFilesCountIsSet() {
                return (this.optBits & 0x10L) != 0L;
            }

            private boolean failedDataFilesCountIsSet() {
                return (this.optBits & 0x20L) != 0L;
            }
        }
    }
}

